/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import java.lang.reflect.InvocationTargetException;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.Context;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.plugins.pinplugin.AbstractPINAction;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.UnblockPINDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnblockPINAction
extends AbstractPINAction {
    private static final Logger logger = LoggerFactory.getLogger(UnblockPINAction.class);

    @Override
    public void execute() {
        try {
            boolean nativePace;
            ConnectionHandleType cHandle = this.waitForCardType("http://bsi.bund.de/cif/npa.xml");
            if (cHandle == null) {
                logger.debug("User cancelled card insertion.");
                return;
            }
            cHandle = this.connectToRootApplication(cHandle);
            RecognizedState pinState = this.recognizeState(cHandle);
            try {
                nativePace = this.genericPACESupport(cHandle);
            }
            catch (WSHelper.WSException e) {
                logger.error("Could not get capabilities from reader.");
                return;
            }
            UnblockPINDialog uc = new UnblockPINDialog(this.gui, this.dispatcher, cHandle, pinState, !nativePace);
            uc.show();
            Disconnect d = new Disconnect();
            d.setSlotHandle(cHandle.getSlotHandle());
            this.dispatcher.deliver(d);
        }
        catch (InvocationTargetException e) {
            logger.error("Failed to execute Action.", e);
        }
        catch (DispatcherException e) {
            logger.error("Failed to execute Action.", e);
        }
    }

    @Override
    public void init(Context aCtx) throws ActionInitializationException {
        this.dispatcher = aCtx.getDispatcher();
        this.gui = aCtx.getUserConsent();
        this.recognition = aCtx.getRecognition();
        this.cardStates = aCtx.getCardStates();
    }

    @Override
    public void destroy() {
    }
}

