/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PasswordTypeType;
import java.io.ByteArrayOutputStream;
import org.openecard.common.USBLangID;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.IntegerUtils;
import org.openecard.common.util.PINUtils;
import org.openecard.common.util.UtilException;
import org.openecard.ifd.scio.IFDException;

public class PCSCPinVerify {
    private final PasswordTypeType pwdType;
    private final int minLen;
    private final int storedLen;
    private final int maxLen;
    public byte bTimeOut = 0;
    public byte bTimeOut2 = (byte)15;
    public byte bmFormatString = 0;
    public byte bmPINBlockString = 0;
    public byte bmPINLengthFormat = 0;
    private short wPINMaxExtraDigit = 0;
    private byte bEntryValidationCondition = (byte)2;
    private byte bNumberMessage = (byte)-1;
    private short wLangId = USBLangID.German_Standard.getCode();
    private byte bMsgIndex = 0;
    private final byte[] bTeoPrologue = new byte[]{0, 0, 0};
    private int ulDataLength = 0;
    private byte[] abData;

    public PCSCPinVerify(PasswordAttributesType attributes, byte[] cmdTemplate) throws IFDException {
        this.pwdType = attributes.getPwdType();
        this.minLen = attributes.getMinLength().intValue();
        this.storedLen = attributes.getStoredLength().intValue();
        this.maxLen = attributes.getMaxLength() != null ? attributes.getMaxLength().intValue() : (this.pwdType == PasswordTypeType.ISO_9564_1 ? this.storedLen * 2 - 2 : (this.pwdType == PasswordTypeType.BCD ? this.storedLen * 2 : this.storedLen));
        this.prepareStructure(attributes, cmdTemplate);
    }

    private void prepareStructure(PasswordAttributesType attributes, byte[] cmdTemplate) throws IFDException {
        byte[] pinTemplate;
        try {
            pinTemplate = PINUtils.createPinMask(attributes);
        }
        catch (UtilException e) {
            IFDException ex = new IFDException(e);
            throw ex;
        }
        byte[] template = cmdTemplate;
        if (pinTemplate.length > 0) {
            template = ByteUtils.concatenate(cmdTemplate, (byte)pinTemplate.length);
            template = ByteUtils.concatenate(template, pinTemplate);
        }
        this.setData(template);
        boolean nibbleHandling = this.pwdType == PasswordTypeType.BCD || this.pwdType == PasswordTypeType.ISO_9564_1;
        boolean isoPin = this.pwdType == PasswordTypeType.ISO_9564_1;
        int pinLenIdx = template.length;
        int pinPos = isoPin ? pinLenIdx + 1 : pinLenIdx;
        int bmSysUnits = 1;
        byte bmPinPos = (byte)(isoPin ? 1 : 0);
        int bmJustify = 0;
        int bmPinType = 0;
        if (nibbleHandling) {
            bmPinType = 1;
        } else if (this.pwdType == PasswordTypeType.ASCII_NUMERIC) {
            bmPinType = 2;
        }
        this.bmFormatString = (byte)(bmSysUnits << 7 | bmPinPos << 3 | bmJustify << 2 | bmPinType);
        byte bmPinManagement = (byte)(isoPin ? 4 : 0);
        byte pinSize = (byte)(isoPin ? this.storedLen - 1 : this.storedLen);
        this.bmPINBlockString = (byte)(bmPinManagement << 4 | pinSize);
        int bmPinLengthUnit = 0;
        byte bmPinBytePos = (byte)(isoPin ? 4 : 0);
        this.bmPINLengthFormat = (byte)(bmPinLengthUnit << 4 | bmPinBytePos);
        this.setMinPINSize((byte)this.minLen);
        this.setMaxPINSize((byte)this.maxLen);
    }

    public void setMinPINSize(byte minSize) {
        this.wPINMaxExtraDigit = (short)(this.wPINMaxExtraDigit & 0xFF | minSize << 8);
    }

    public byte getMinPINSize() {
        return (byte)(this.wPINMaxExtraDigit >> 8 & 0xFF);
    }

    public void setMaxPINSize(byte maxSize) {
        this.wPINMaxExtraDigit = (short)(this.wPINMaxExtraDigit & 0xFF00 | maxSize);
    }

    public byte getMaxPINSize() {
        return (byte)(this.wPINMaxExtraDigit & 0xFF);
    }

    public void setData(byte[] data) {
        if (data != null) {
            this.ulDataLength = data.length;
            this.abData = data;
        }
    }

    public byte[] toBytes() {
        int i;
        ByteArrayOutputStream o = new ByteArrayOutputStream(42);
        o.write(this.bTimeOut);
        o.write(this.bTimeOut2);
        o.write(this.bmFormatString);
        o.write(this.bmPINBlockString);
        o.write(this.bmPINLengthFormat);
        o.write(this.getMaxPINSize());
        o.write(this.getMinPINSize());
        o.write(this.bEntryValidationCondition);
        o.write(this.bNumberMessage);
        byte lang_low = (byte)(this.wLangId & 0xFF);
        byte lang_high = (byte)(this.wLangId >> 8 & 0xFF);
        o.write(lang_high);
        o.write(lang_low);
        o.write(this.bMsgIndex);
        o.write(this.bTeoPrologue, 0, this.bTeoPrologue.length);
        byte[] ulDataLength_bytes = IntegerUtils.toByteArray(this.ulDataLength);
        for (i = ulDataLength_bytes.length - 1; i >= 0; --i) {
            o.write(ulDataLength_bytes[i]);
        }
        for (i = ulDataLength_bytes.length; i < 4; ++i) {
            o.write(0);
        }
        if (this.ulDataLength > 0) {
            o.write(this.abData, 0, this.abData.length);
        }
        byte[] result = o.toByteArray();
        return result;
    }
}

