/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.PinInputType;
import java.util.Map;
import org.openecard.gui.StepResult;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.reader.PCSCPinVerify;
import org.openecard.ifd.scio.wrapper.SCTerminal;

public class NativePinStepAction
extends StepAction {
    public IFDException exception = null;
    public byte[] response = null;
    private final PinInputType pinInput;
    private final SCTerminal term;
    private final byte[] template;

    public NativePinStepAction(String stepName, PinInputType pinInput, SCTerminal term, byte[] template) {
        super(stepName);
        this.pinInput = pinInput;
        this.term = term;
        this.template = template;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        try {
            this.response = NativePinStepAction.nativePinVerify(this.pinInput, this.term, this.template);
        }
        catch (IFDException ex) {
            this.exception = ex;
        }
        return new StepActionResult(StepActionResultStatus.NEXT);
    }

    private static byte[] nativePinVerify(PinInputType pinInput, SCTerminal term, byte[] template) throws IFDException {
        PCSCPinVerify verifyStruct = new PCSCPinVerify(pinInput.getPasswordAttributes(), template);
        byte[] verifyStructData = verifyStruct.toBytes();
        byte[] result = term.executeCtrlCode(6, verifyStructData);
        return result;
    }
}

