/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace;

import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import java.io.UnsupportedEncodingException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.ifd.Protocol;
import org.openecard.common.ifd.anytype.PACEInputType;
import org.openecard.common.ifd.anytype.PACEOutputType;
import org.openecard.common.ifd.protocol.exception.ProtocolException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.crypto.common.asn1.eac.PACESecurityInfos;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.crypto.common.asn1.eac.ef.EFCardAccess;
import org.openecard.gui.UserConsent;
import org.openecard.ifd.protocol.pace.PACEImplementation;
import org.openecard.ifd.protocol.pace.PACEUserConsent;
import org.openecard.ifd.protocol.pace.SecureMessaging;
import org.openecard.ifd.protocol.pace.gui.GUIContentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PACEProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(PACEProtocol.class.getName());
    private SecureMessaging sm;

    @Override
    public EstablishChannelResponse establish(EstablishChannel req, Dispatcher dispatcher, UserConsent gui) {
        EstablishChannelResponse response = new EstablishChannelResponse();
        try {
            byte[] pin;
            PACEInputType paceInput = new PACEInputType(req.getAuthenticationProtocolData());
            byte pinID = paceInput.getPINID();
            byte[] chat = paceInput.getCHAT();
            if (paceInput.getPIN() == null || paceInput.getPIN().isEmpty()) {
                GUIContentMap content = new GUIContentMap();
                content.add(GUIContentMap.ELEMENT.PIN_ID, (Object)pinID);
                PACEUserConsent paceUserConsent = new PACEUserConsent(gui);
                paceUserConsent.show(content);
                pin = ((String)content.get(GUIContentMap.ELEMENT.PIN)).getBytes("ISO-8859-1");
            } else {
                pin = paceInput.getPIN().getBytes("ISO-8859-1");
            }
            if (pin == null || pin.length == 0) {
                response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "No PIN was entered."));
                return response;
            }
            byte[] slotHandle = req.getSlotHandle();
            byte[] efcadata = CardUtils.readFile(dispatcher, slotHandle, (short)284);
            SecurityInfos sis = SecurityInfos.getInstance(efcadata);
            EFCardAccess efca = new EFCardAccess(sis);
            PACESecurityInfos psi = efca.getPACESecurityInfos();
            PACEImplementation pace = new PACEImplementation(dispatcher, slotHandle, psi);
            pace.execute(pin, pinID, chat);
            this.sm = new SecureMessaging(pace.getKeyMAC(), pace.getKeyENC());
            PACEOutputType paceOutput = paceInput.getOutputType();
            paceOutput.setEFCardAccess(efcadata);
            paceOutput.setCurrentCAR(pace.getCurrentCAR());
            paceOutput.setPreviousCAR(pace.getPreviousCAR());
            paceOutput.setIDPICC(pace.getIDPICC());
            paceOutput.setRetryCounter(pace.getRetryCounter());
            response.setResult(WSHelper.makeResultOK());
            response.setAuthenticationProtocolData(paceOutput.getAuthDataType());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), ex);
            response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownPINFormat", "Cannot encode the PIN in ISO-8859-1 charset."));
        }
        catch (ProtocolException ex) {
            logger.error(ex.getMessage(), ex);
            response.setResult(WSHelper.makeResult(ex));
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            response.setResult(WSHelper.makeResult(ex));
        }
        return response;
    }

    @Override
    public byte[] applySM(byte[] commandAPDU) {
        try {
            if (this.sm != null) {
                return this.sm.encrypt(commandAPDU);
            }
            throw new RuntimeException("No established Secure Messaging channel available");
        }
        catch (Exception ex) {
            this.sm = null;
            logger.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] removeSM(byte[] responseAPDU) {
        try {
            if (this.sm != null) {
                return this.sm.decrypt(responseAPDU);
            }
            throw new RuntimeException("No established Secure Messaging channel available");
        }
        catch (Exception ex) {
            this.sm = null;
            logger.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }
}

