/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.crypto.common.keystore.KeyStoreSignerFinder;
import org.openecard.crypto.common.sal.CredentialNotFound;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.auth.KeyStoreCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredentialFactory
implements CredentialFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreCredentialFactory.class);
    private final KeyStoreSignerFinder finder;

    public KeyStoreCredentialFactory(@Nonnull KeyStoreSignerFinder finder) {
        this.finder = finder;
    }

    @Override
    public List<TlsCredentials> getClientCredentials(CertificateRequest cr) {
        ArrayList<KeyStoreCredential> credentials = new ArrayList<KeyStoreCredential>(1);
        try {
            KeyStoreCredential cred = new KeyStoreCredential(this.finder.findFirstMatching(cr));
            credentials.add(cred);
        }
        catch (CredentialNotFound e) {
            logger.error("No suitable credential found. Returning empty list.");
        }
        return Collections.unmodifiableList(credentials);
    }
}

