/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import java.io.IOException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import javax.annotation.Nonnull;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.openecard.crypto.common.keystore.KeyStoreSigner;
import org.openecard.crypto.common.sal.CredentialPermissionDenied;
import org.openecard.crypto.tls.auth.SmartCardSignerCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredential
implements TlsSignerCredentials {
    private static final Logger logger = LoggerFactory.getLogger(SmartCardSignerCredential.class);
    private final KeyStoreSigner signer;
    private Certificate certificate = Certificate.EMPTY_CHAIN;

    public KeyStoreCredential(@Nonnull KeyStoreSigner signer) {
        this.signer = signer;
    }

    @Override
    public Certificate getCertificate() {
        if (this.certificate.equals(Certificate.EMPTY_CHAIN)) {
            try {
                this.certificate = this.signer.getBCCertificateChain();
            }
            catch (IOException ex) {
                logger.error("Failed to read certificate due to an unknown error.", ex);
            }
            catch (CredentialPermissionDenied ex) {
                logger.error("Failed to get certificate because of missing permissions.", ex);
            }
            catch (CertificateException ex) {
                logger.error("Failed to deserialize certificate.", ex);
            }
        }
        return this.certificate;
    }

    @Override
    public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
        try {
            return this.signer.sign(md5andsha1);
        }
        catch (SignatureException ex) {
            throw new IOException("Failed to create signature because of an unknown error.", ex);
        }
        catch (CredentialPermissionDenied ex) {
            throw new IOException("Failed to create signature because of missing permissions.", ex);
        }
    }
}

