/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.crypto.tls.CertificateVerifier;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAuthentication
implements TlsAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(DynamicAuthentication.class);
    private String hostname;
    private CertificateVerifier certVerifier;
    private CredentialFactory credentialFactory;
    private Certificate lastCertChain;

    public DynamicAuthentication() {
    }

    public DynamicAuthentication(@Nullable String hostName, @Nullable CertificateVerifier certVerifier, @Nullable CredentialFactory credentialFactory) {
        this.hostname = hostName;
        this.certVerifier = certVerifier;
        this.credentialFactory = credentialFactory;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setCertificateVerifier(CertificateVerifier certVerifier) {
        this.certVerifier = certVerifier;
    }

    public void setCredentialFactory(@Nullable CredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
    }

    @Override
    public void notifyServerCertificate(Certificate crtfct) throws IOException {
        this.lastCertChain = crtfct;
        if (this.certVerifier != null) {
            if (this.hostname != null) {
                this.certVerifier.isValid(crtfct, this.hostname);
            } else {
                logger.warn("Hostname not available for certificate verification.");
                this.certVerifier.isValid(crtfct);
            }
        } else {
            logger.warn("No certificate verifier available, skipping certificate verification.");
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest cr) {
        List<TlsCredentials> credentials;
        if (this.credentialFactory != null && !(credentials = this.credentialFactory.getClientCredentials(cr)).isEmpty()) {
            return credentials.get(0);
        }
        return new TlsCredentials(){

            @Override
            public Certificate getCertificate() {
                return Certificate.EMPTY_CHAIN;
            }
        };
    }

    @Nullable
    public Certificate getServerCertificate() {
        return this.lastCertChain;
    }
}

