/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.impl.DefaultConnectionReuseStrategy;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.TlsClientProtocol;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.FileUtils;
import org.openecard.control.module.tctoken.ConnectionError;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TlsConnectionHandler;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.HttpUtils;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetTask
implements Callable<StartPAOSResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HttpGetTask.class);
    private final Dispatcher dispatcher;
    private final ConnectionHandleType connectionHandle;
    private final TCTokenRequest tokenRequest;

    public HttpGetTask(Dispatcher dispatcher, ConnectionHandleType connectionHandle, TCTokenRequest tokenRequest) {
        this.dispatcher = dispatcher;
        this.connectionHandle = connectionHandle;
        this.tokenRequest = tokenRequest;
    }

    @Override
    public StartPAOSResponse call() throws Exception {
        this.getRequest();
        StartPAOSResponse response = (StartPAOSResponse)WSHelper.makeResponse(StartPAOSResponse.class, WSHelper.makeResultOK());
        return response;
    }

    private void getRequest() throws IOException, ConnectionError, URISyntaxException, HttpException {
        TlsClientProtocol handler;
        TlsConnectionHandler tlsHandler = new TlsConnectionHandler(this.dispatcher, this.tokenRequest, this.connectionHandle);
        tlsHandler.setUpClient();
        try {
            handler = tlsHandler.createTlsConnection(ProtocolVersion.TLSv11);
        }
        catch (IOException ex) {
            logger.error("Connecting to the TLS endpoint with TLSv1.1 failed. Falling back to TLSv1.0.", ex);
            handler = tlsHandler.createTlsConnection(ProtocolVersion.TLSv10);
        }
        InputStream in = handler.getInputStream();
        OutputStream out = handler.getOutputStream();
        StreamHttpClientConnection conn = new StreamHttpClientConnection(in, out);
        BasicHttpContext ctx = new BasicHttpContext();
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        DefaultConnectionReuseStrategy reuse = new DefaultConnectionReuseStrategy();
        String resource = tlsHandler.getResource();
        BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("GET", resource);
        req.setParams(conn.getParams());
        HttpRequestHelper.setDefaultHeader((HttpRequest)req, tlsHandler.getServerAddress());
        req.setHeader("PAOS", "ver=\"urn:liberty:paos:2006-08\"");
        req.setHeader("Accept", "text/html; */*");
        HttpUtils.dumpHttpRequest(logger, req);
        HttpResponse response = httpexecutor.execute(req, conn, ctx);
        int statusCode = response.getStatusLine().getStatusCode();
        conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        byte[] entityData = FileUtils.toByteArray(entity.getContent());
        HttpUtils.dumpHttpResponse(logger, response, entityData);
        conn.close();
        if (statusCode < 200 || statusCode > 299) {
            throw new ConnectionError("Result returned from server is not OK (" + statusCode + ")");
        }
    }
}

