/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http;

import java.io.IOException;
import org.openecard.addon.AddonManager;
import org.openecard.apache.http.protocol.BasicHttpProcessor;
import org.openecard.control.binding.http.HTTPService;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.handler.HttpAppPluginActionHandler;
import org.openecard.control.binding.http.interceptor.CORSResponseInterceptor;
import org.openecard.control.binding.http.interceptor.ErrorResponseInterceptor;
import org.openecard.control.binding.http.interceptor.StatusLineResponseInterceptor;

public class HTTPBinding {
    public static final int DEFAULT_PORT = 24727;
    private final int port;
    private final DocumentRoot documentRoot;
    private BasicHttpProcessor interceptors;
    private HTTPService service;
    private AddonManager addonManager;

    public void setAddonManager(AddonManager addonManager) {
        this.addonManager = addonManager;
    }

    public HTTPBinding() throws IOException, Exception {
        this(24727);
    }

    public HTTPBinding(int port) throws IOException, Exception {
        this(port, "/www", "/www-files");
    }

    public HTTPBinding(int port, String documentRootPath, String listFile) throws IOException, Exception {
        this.port = port;
        this.documentRoot = new DocumentRoot(documentRootPath, listFile);
    }

    public void setInterceptors(BasicHttpProcessor interceptors) {
        this.interceptors = interceptors;
    }

    public void start() throws Exception {
        if (this.interceptors == null || this.interceptors.getRequestInterceptorCount() == 0 || this.interceptors.getResponseInterceptorCount() == 0) {
            this.interceptors = new BasicHttpProcessor();
            this.interceptors.addInterceptor(new StatusLineResponseInterceptor());
            this.interceptors.addInterceptor(new ErrorResponseInterceptor(this.documentRoot, "/templates/error.html"));
            this.interceptors.addInterceptor(new CORSResponseInterceptor());
        }
        this.service = new HTTPService(this.port, new HttpAppPluginActionHandler(this.addonManager), this.interceptors);
        this.service.start();
    }

    public void stop() throws Exception {
        this.service.interrupt();
    }

    public int getPort() {
        return this.service.getPort();
    }
}

