/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state.cif;

import iso.std.iso_iec._24727.tech.schema.AccessRuleType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.SecurityConditionType;
import java.util.HashMap;
import java.util.Map;

public class DataSetInfoWrapper {
    private DataSetInfoType dataSetInfo;
    private Map<Enum<?>, SecurityConditionType> securityConditions = new HashMap();

    public DataSetInfoWrapper(DataSetInfoType dataSetInfo) {
        this.dataSetInfo = dataSetInfo;
    }

    public DataSetInfoType getDataSetInfo() {
        return this.dataSetInfo;
    }

    public SecurityConditionType getSecurityCondition(Enum<?> serviceAction) {
        if (this.securityConditions.isEmpty()) {
            for (AccessRuleType accessRule : this.dataSetInfo.getDataSetACL().getAccessRule()) {
                if (accessRule.getAction().getConnectionServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getConnectionServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getAuthorizationServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getAuthorizationServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getDifferentialIdentityServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getDifferentialIdentityServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getNamedDataServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getNamedDataServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCryptographicServiceAction() != null) {
                    this.securityConditions.put(accessRule.getAction().getCryptographicServiceAction(), accessRule.getSecurityCondition());
                    continue;
                }
                if (accessRule.getAction().getCardApplicationServiceAction() == null) continue;
                this.securityConditions.put(accessRule.getAction().getCardApplicationServiceAction(), accessRule.getSecurityCondition());
            }
        }
        return this.securityConditions.get(serviceAction);
    }
}

