/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.util.ByteComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardStateMap {
    private static final Logger _logger = LoggerFactory.getLogger(CardStateMap.class);
    private final TreeSet<CardStateEntry> allEntries = new TreeSet();
    private final ConcurrentSkipListMap<String, Set<CardStateEntry>> sessionMap = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<byte[], Set<CardStateEntry>> contextMap = new ConcurrentSkipListMap(new ByteComparator());
    private final ConcurrentSkipListMap<byte[], Set<CardStateEntry>> slothandleMap = new ConcurrentSkipListMap(new ByteComparator());

    public synchronized CardStateEntry getEntry(ConnectionHandleType handle) {
        return this.getEntry(handle);
    }

    public synchronized CardStateEntry getEntry(ConnectionHandleType handle, boolean filterAppId) {
        Set<CardStateEntry> entry = this.getMatchingEntries(handle, filterAppId);
        int size = entry.size();
        if (size == 1) {
            return entry.iterator().next();
        }
        if (size == 0) {
            _logger.warn("No state entry found for the given ConnectionHandle.");
        } else {
            _logger.warn("More than one state entry found for the given ConnectionHandle.");
        }
        return null;
    }

    public synchronized void addEntry(CardStateEntry entry) {
        ConnectionHandleType handle = entry.handleCopy();
        ChannelHandleType channel = handle.getChannelHandle();
        if (channel != null) {
            this.addMapEntry(channel.getSessionIdentifier(), this.sessionMap, entry);
        }
        this.addMapEntry(handle.getContextHandle(), this.contextMap, entry);
        this.addMapEntry(handle.getSlotHandle(), this.slothandleMap, entry);
        this.allEntries.add(entry);
    }

    public synchronized void removeEntry(ConnectionHandleType handle) {
        boolean removeSlotHandles;
        Set<CardStateEntry> entries = this.getMatchingEntries(handle);
        Iterator<CardStateEntry> it = entries.iterator();
        boolean bl = removeSlotHandles = handle.getSlotHandle() == null;
        while (it.hasNext()) {
            CardStateEntry entry = it.next();
            this.removeEntry(entry, removeSlotHandles);
        }
    }

    public synchronized void removeSlotHandleEntry(byte[] slotHandle) {
        ConnectionHandleType handle = new ConnectionHandleType();
        handle.setSlotHandle(slotHandle);
        Set<CardStateEntry> entries = this.getMatchingEntries(handle);
        Iterator<CardStateEntry> it = entries.iterator();
        if (it.hasNext()) {
            CardStateEntry entry = it.next();
            this.removeMapEntry(handle.getSlotHandle(), this.slothandleMap, entry);
            this.clearProtocolsForEntry(entry);
        }
    }

    private void clearProtocolsForEntry(CardStateEntry entry) {
        CardStateEntry allEntriesEntry;
        Iterator<CardStateEntry> it = this.allEntries.iterator();
        if (it.hasNext() && entry.equals(allEntriesEntry = it.next())) {
            allEntriesEntry.removeAllProtocols();
        }
    }

    private synchronized void removeEntry(CardStateEntry entry, boolean removeSlotHandles) {
        ConnectionHandleType handle = entry.handleCopy();
        ChannelHandleType channel = handle.getChannelHandle();
        if (channel != null) {
            this.removeMapEntry(channel.getSessionIdentifier(), this.sessionMap, entry);
        }
        this.removeMapEntry(handle.getContextHandle(), this.contextMap, entry);
        if (removeSlotHandles) {
            for (byte[] key : this.slothandleMap.keySet()) {
                this.removeMapEntry(key, this.slothandleMap, entry);
            }
        } else {
            this.removeMapEntry(handle.getSlotHandle(), this.slothandleMap, entry);
        }
        this.allEntries.remove(entry);
    }

    private <K> void addMapEntry(K key, ConcurrentSkipListMap<K, Set<CardStateEntry>> map, CardStateEntry entry) {
        if (key != null) {
            Set<CardStateEntry> entrySet = CardStateMap.setFromMap(map, key);
            boolean empty = entrySet.isEmpty();
            entrySet.add(entry);
            if (empty) {
                map.put(key, entrySet);
            }
        }
    }

    private <K> void removeMapEntry(K key, ConcurrentSkipListMap<K, Set<CardStateEntry>> map, CardStateEntry entry) {
        if (key != null && map.containsKey(key)) {
            Set<CardStateEntry> entrySet = map.get(key);
            entrySet.remove(entry);
            if (entrySet.isEmpty()) {
                map.remove(key);
            }
        }
    }

    public Set<CardStateEntry> getMatchingEntries(ConnectionHandleType cHandle) {
        return this.getMatchingEntries(cHandle, true);
    }

    public Set<CardStateEntry> getMatchingEntries(ConnectionHandleType cHandle, boolean filterAppId) {
        return this.getMatchingEntries(cHandle, cHandle.getSlotHandle(), cHandle.getRecognitionInfo(), filterAppId);
    }

    public Set<CardStateEntry> getMatchingEntries(CardApplicationPathType cHandle) {
        return this.getMatchingEntries(cHandle, true);
    }

    public Set<CardStateEntry> getMatchingEntries(CardApplicationPathType cHandle, boolean filterAppId) {
        return this.getMatchingEntries(cHandle, null, null, filterAppId);
    }

    private synchronized Set<CardStateEntry> getMatchingEntries(CardApplicationPathType cHandle, byte[] slotHandle, ConnectionHandleType.RecognitionInfo recInfo, boolean filterAppId) {
        Set<CardStateEntry> mergedSets;
        ChannelHandleType channel = cHandle.getChannelHandle();
        String session = channel != null ? channel.getSessionIdentifier() : null;
        byte[] ctx = cHandle.getContextHandle();
        String ifdname = cHandle.getIFDName();
        BigInteger slotIdx = cHandle.getSlotIndex();
        byte[] cardApplication = cHandle.getCardApplication();
        if (session == null && ctx == null && slotHandle == null) {
            mergedSets = new TreeSet<CardStateEntry>((SortedSet<CardStateEntry>)this.allEntries);
        } else {
            Set<CardStateEntry> sessionEntries = CardStateMap.setFromMap(this.sessionMap, session);
            Set<CardStateEntry> ctxEntries = CardStateMap.setFromMap(this.contextMap, ctx);
            Set<CardStateEntry> slothandleEntries = CardStateMap.setFromMap(this.slothandleMap, slotHandle);
            ArrayList<Set<CardStateEntry>> setsToMerge = new ArrayList<Set<CardStateEntry>>(3);
            if (session != null) {
                setsToMerge.add(sessionEntries);
            }
            if (ctx != null) {
                setsToMerge.add(ctxEntries);
            }
            if (slotHandle != null) {
                setsToMerge.add(slothandleEntries);
            }
            mergedSets = CardStateMap.mergeSets(setsToMerge);
        }
        if (slotIdx != null) {
            CardStateMap.filterIdx(mergedSets, slotIdx);
        }
        if (ifdname != null) {
            CardStateMap.filterIfdname(mergedSets, ifdname);
        }
        if (filterAppId && cardApplication != null) {
            CardStateMap.filterCardApplication(mergedSets, cardApplication);
        }
        if (recInfo != null && recInfo.getCardType() != null) {
            CardStateMap.filterCardType(mergedSets, recInfo.getCardType());
        }
        return mergedSets;
    }

    private static <K> Set<CardStateEntry> setFromMap(ConcurrentSkipListMap<K, Set<CardStateEntry>> map, K key) {
        Set<Object> result = null;
        if (key != null) {
            result = map.get(key);
        }
        return result != null ? result : new TreeSet();
    }

    private static void filterIdx(Set<CardStateEntry> entries, BigInteger idx) {
        Iterator<CardStateEntry> it = entries.iterator();
        while (it.hasNext()) {
            CardStateEntry next = it.next();
            if (!next.hasSlotIdx() || next.matchSlotIdx(idx)) continue;
            it.remove();
        }
    }

    private static void filterCardApplication(Set<CardStateEntry> entries, byte[] cardApplication) {
        Iterator<CardStateEntry> it = entries.iterator();
        while (it.hasNext()) {
            CardStateEntry next = it.next();
            if (Arrays.equals(next.getCurrentCardApplication().getApplicationIdentifier(), cardApplication)) continue;
            it.remove();
        }
    }

    private static void filterIfdname(Set<CardStateEntry> entries, String ifdName) {
        Iterator<CardStateEntry> it = entries.iterator();
        while (it.hasNext()) {
            CardStateEntry next = it.next();
            String otherName = next.getIfdName();
            if (otherName == null || otherName.equals(ifdName)) continue;
            it.remove();
        }
    }

    private static void filterCardType(Set<CardStateEntry> entries, String cardType) {
        Iterator<CardStateEntry> it = entries.iterator();
        while (it.hasNext()) {
            CardStateEntry next = it.next();
            String otherType = next.getCardType();
            if (otherType.equals(cardType)) continue;
            it.remove();
        }
    }

    private static Set<CardStateEntry> mergeSets(ArrayList<Set<CardStateEntry>> setsToMerge) {
        TreeSet<CardStateEntry> result = new TreeSet<CardStateEntry>();
        if (setsToMerge.isEmpty()) {
            return Collections.emptySet();
        }
        result.addAll((Collection)setsToMerge.get(0));
        if (setsToMerge.size() >= 2) {
            for (Set<CardStateEntry> nextSet : setsToMerge.subList(1, setsToMerge.size())) {
                Iterator<CardStateEntry> it = result.iterator();
                while (it.hasNext()) {
                    CardStateEntry nextEntry = it.next();
                    if (nextSet.contains(nextEntry)) continue;
                    it.remove();
                }
            }
        }
        return result;
    }
}

