/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.symmetric;

import org.openecard.bouncycastle.crypto.CipherKeyGenerator;
import org.openecard.bouncycastle.crypto.engines.CAST6Engine;
import org.openecard.bouncycastle.crypto.macs.GMac;
import org.openecard.bouncycastle.crypto.modes.GCMBlockCipher;
import org.openecard.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public final class CAST6 {
    private CAST6() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = CAST6.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CAST6", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.CAST6", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "CAST6", PREFIX + "$GMAC", PREFIX + "$KeyGen");
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new CAST6Engine());
        }
    }
}

