/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.openecard.bouncycastle.crypto.io.SignerInputStream;
import org.openecard.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.DHParameters;
import org.openecard.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.openecard.bouncycastle.crypto.tls.CombinedHash;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsDHUtils;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsSigner;
import org.openecard.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms, dhParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DHKeyPairGenerator kpg = new DHKeyPairGenerator();
        kpg.init(new DHKeyGenerationParameters(this.context.getSecureRandom(), this.dhParameters));
        AsymmetricCipherKeyPair kp = kpg.generateKeyPair();
        BigInteger Ys = ((DHPublicKeyParameters)kp.getPublic()).getY();
        TlsDHUtils.writeDHParameter(this.dhParameters.getP(), buf);
        TlsDHUtils.writeDHParameter(this.dhParameters.getG(), buf);
        TlsDHUtils.writeDHParameter(Ys, buf);
        byte[] digestInput = buf.toByteArray();
        CombinedHash d = new CombinedHash();
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        d.update(digestInput, 0, digestInput.length);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] sigBytes = this.serverCredentials.generateCertificateSignature(hash);
        TlsUtils.writeOpaque16(sigBytes, buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initVerifyer(this.tlsSigner, securityParameters);
        SignerInputStream sigIn = new SignerInputStream(input, signer);
        BigInteger p = TlsDHUtils.readDHParameter(sigIn);
        BigInteger g = TlsDHUtils.readDHParameter(sigIn);
        BigInteger Ys = TlsDHUtils.readDHParameter(sigIn);
        byte[] sigBytes = TlsUtils.readOpaque16(input);
        if (!signer.verifySignature(sigBytes)) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

