/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClasspathRegistry
implements AddonRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathRegistry.class);
    private final ArrayList<AddonSpecification> registeredAddons = new ArrayList();

    public ClasspathRegistry() throws WSMarshallerException {
        Document manifestDoc;
        InputStream manifestStream;
        String name;
        WSMarshaller marshaller = WSMarshallerFactory.createInstance();
        marshaller.addXmlTypeClass(AddonSpecification.class);
        try {
            name = "TCToken-Manifest.xml";
            manifestStream = FileUtils.resolveResourceAsStream(ClasspathRegistry.class, name);
            manifestDoc = marshaller.str2doc(manifestStream);
            this.register((AddonSpecification)marshaller.unmarshal(manifestDoc));
            logger.info("Loaded TR-03112 Add-on.");
        }
        catch (IOException ex) {
            logger.warn("Failed to load TR-03112 Add-on.", ex);
        }
        catch (SAXException ex) {
            logger.warn("Failed to load TR-03112 Add-on.", ex);
        }
        catch (WSMarshallerException ex) {
            logger.warn("Failed to load TR-03112 Add-on.", ex);
        }
        try {
            name = "PIN-Plugin-Manifest.xml";
            manifestStream = FileUtils.resolveResourceAsStream(ClasspathRegistry.class, name);
            manifestDoc = marshaller.str2doc(manifestStream);
            this.register((AddonSpecification)marshaller.unmarshal(manifestDoc));
            logger.info("Loaded PIN-Management Add-on.");
        }
        catch (IOException ex) {
            logger.warn("Failed to load PIN-Management Add-on.", ex);
        }
        catch (SAXException ex) {
            logger.warn("Failed to load PIN-Management Add-on.", ex);
        }
        catch (WSMarshallerException ex) {
            logger.warn("Failed to load PIN-Management Add-on.", ex);
        }
        try {
            name = "GenericCrypto-Plugin-Manifest.xml";
            manifestStream = FileUtils.resolveResourceAsStream(ClasspathRegistry.class, name);
            manifestDoc = marshaller.str2doc(manifestStream);
            this.register((AddonSpecification)marshaller.unmarshal(manifestDoc));
            logger.info("Loaded GenericCrypto Add-on.");
        }
        catch (IOException ex) {
            logger.warn("Failed to load GenericCrypto Add-on.", ex);
        }
        catch (SAXException ex) {
            logger.warn("Failed to load GenericCrypto Add-on.", ex);
        }
        catch (WSMarshallerException ex) {
            logger.warn("Failed to load GenericCrypto Add-on.", ex);
        }
        try {
            name = "Status-Plugin-Manifest.xml";
            manifestStream = FileUtils.resolveResourceAsStream(ClasspathRegistry.class, name);
            manifestDoc = marshaller.str2doc(manifestStream);
            this.register((AddonSpecification)marshaller.unmarshal(manifestDoc));
            logger.info("Loaded Status Add-on.");
        }
        catch (IOException ex) {
            logger.warn("Failed to load Status Add-on.", ex);
        }
        catch (SAXException ex) {
            logger.warn("Failed to load Status Add-on.", ex);
        }
        catch (WSMarshallerException ex) {
            logger.warn("Failed to load Status Add-on.", ex);
        }
    }

    public final void register(AddonSpecification desc) {
        this.registeredAddons.add(desc);
    }

    @Override
    public Set<AddonSpecification> listPlugins() {
        HashSet<AddonSpecification> list = new HashSet<AddonSpecification>();
        list.addAll(this.registeredAddons);
        return list;
    }

    @Override
    public AddonSpecification search(String id) {
        for (AddonSpecification desc : this.registeredAddons) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public Set<AddonSpecification> searchByName(String name) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.registeredAddons) {
            for (LocalizedString s : desc.getLocalizedName()) {
                if (!s.getValue().equals(name)) continue;
                matchingAddons.add(desc);
            }
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchIFDProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.registeredAddons) {
            ProtocolPluginSpecification protocolDesc = desc.searchIFDActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchSALProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.registeredAddons) {
            ProtocolPluginSpecification protocolDesc = desc.searchSALActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public ClassLoader downloadPlugin(AddonSpecification addonSpec) {
        return this.getClass().getClassLoader();
    }

    @Override
    public Set<AddonSpecification> searchByResourceName(String resourceName) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.registeredAddons) {
            AppPluginSpecification actionDesc = desc.searchByResourceName(resourceName);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchByActionId(String actionId) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.registeredAddons) {
            AppExtensionSpecification actionDesc = desc.searchByActionId(actionId);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }
}

