/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.StepResult;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.swing.DialogWrapper;
import org.openecard.gui.swing.NavigationBar;
import org.openecard.gui.swing.StepBar;
import org.openecard.gui.swing.StepFrame;
import org.openecard.gui.swing.SwingStepResult;
import org.openecard.gui.swing.common.NavigationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingNavigator
implements UserConsentNavigator,
ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(SwingNavigator.class);
    private final DialogWrapper dialogWrapper;
    private final Container stepContainer;
    private final ArrayList<StepFrame> stepFrames;
    private final NavigationBar navBar;
    private final StepBar stepBar;
    private final String dialogType;
    private int stepPointer = -1;
    private Future action;

    public SwingNavigator(DialogWrapper dialogWrapper, String dialogType, List<Step> steps, Container stepContainer, NavigationBar navPanel, StepBar stepBar) {
        this.dialogWrapper = dialogWrapper;
        this.stepContainer = stepContainer;
        this.dialogType = dialogType;
        this.stepFrames = this.createStepFrames(steps, dialogType);
        this.navBar = navPanel;
        this.stepBar = stepBar;
        this.dialogWrapper.show();
    }

    @Override
    public boolean hasNext() {
        return this.stepPointer < this.stepFrames.size() - 1;
    }

    @Override
    public StepResult current() {
        this.stepBar.disableLoaderImage();
        this.selectIdx(this.stepPointer);
        StepFrame frame = this.stepFrames.get(this.stepPointer);
        this.clickIfInstantReturn(frame);
        return frame.getStepResult();
    }

    @Override
    public StepResult next() {
        this.stepBar.disableLoaderImage();
        if (this.hasNext()) {
            this.selectIdx(this.stepPointer + 1);
            StepFrame frame = this.stepFrames.get(this.stepPointer);
            this.clickIfInstantReturn(frame);
            return frame.getStepResult();
        }
        return new SwingStepResult(null, ResultStatus.CANCEL);
    }

    @Override
    public StepResult previous() {
        this.stepBar.disableLoaderImage();
        if (this.stepPointer > 0) {
            this.selectIdx(this.stepPointer - 1);
            StepFrame frame = this.stepFrames.get(this.stepPointer);
            this.clickIfInstantReturn(frame);
            return frame.getStepResult();
        }
        return new SwingStepResult(null, ResultStatus.CANCEL);
    }

    @Override
    public StepResult replaceCurrent(Step step) {
        this.stepBar.disableLoaderImage();
        this.stepFrames.remove(this.stepPointer);
        StepFrame sf = new StepFrame(step, this.dialogType);
        this.stepFrames.add(this.stepPointer, sf);
        this.selectIdx(this.stepPointer);
        this.clickIfInstantReturn(sf);
        return sf.getStepResult();
    }

    @Override
    public StepResult replaceNext(Step step) {
        this.stepBar.disableLoaderImage();
        ++this.stepPointer;
        if (this.stepPointer < this.stepFrames.size()) {
            this.stepFrames.remove(this.stepPointer);
        }
        StepFrame sf = new StepFrame(step, this.dialogType);
        this.stepFrames.add(this.stepPointer, sf);
        this.selectIdx(this.stepPointer);
        this.clickIfInstantReturn(sf);
        return sf.getStepResult();
    }

    @Override
    public StepResult replacePrevious(Step step) {
        this.stepBar.disableLoaderImage();
        if (this.stepPointer > 0) {
            --this.stepPointer;
            this.stepFrames.remove(this.stepPointer);
        }
        StepFrame sf = new StepFrame(step, this.dialogType);
        this.stepFrames.add(this.stepPointer, sf);
        this.selectIdx(this.stepPointer);
        this.clickIfInstantReturn(sf);
        return sf.getStepResult();
    }

    @Override
    public void setRunningAction(Future action) {
        this.action = action;
    }

    @Override
    public void close() {
        this.dialogWrapper.hide();
    }

    private ArrayList<StepFrame> createStepFrames(List<Step> steps, String dialogType) {
        ArrayList<StepFrame> frames = new ArrayList<StepFrame>(steps.size());
        for (int i = 0; i < steps.size(); ++i) {
            if (i == 0) {
                steps.get(0).setReversible(false);
            }
            Step s = steps.get(i);
            StepFrame sf = new StepFrame(s, dialogType);
            frames.add(sf);
        }
        return frames;
    }

    private void selectIdx(int idx) {
        StepFrame nextStep = this.stepFrames.get(idx);
        this.stepBar.selectIdx(idx);
        this.navBar.selectIdx(idx);
        Container nextPanel = nextStep.getPanel();
        nextStep.resetResult();
        this.stepContainer.removeAll();
        this.stepContainer.add(nextPanel);
        this.stepContainer.validate();
        this.stepContainer.repaint();
        this.stepPointer = idx;
        nextStep.updateFrame();
        nextStep.unlockControls();
        this.navBar.unlockControls();
    }

    private void clickIfInstantReturn(StepFrame frame) {
        if (frame.isInstantReturn()) {
            String command = "Button.next";
            final ActionEvent e = new ActionEvent(frame.getStep(), 1001, command);
            new Thread("Instant-Return-Thread"){

                @Override
                public void run() {
                    SwingNavigator.this.actionPerformed(e);
                }
            }.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug("Received event: {}", (Object)e.getActionCommand());
        NavigationEvent event = NavigationEvent.fromEvent(e);
        if (event == null) {
            logger.error("Unknown event received: {}", (Object)e.getActionCommand());
            return;
        }
        StepFrame curStep = this.stepFrames.get(this.stepPointer);
        if (event == NavigationEvent.NEXT && !curStep.validateComponents()) {
            logger.debug("Validation of components failed.");
            return;
        }
        if (this.action != null && !this.action.isDone()) {
            logger.debug("Canceling execution of the currently running StepAction.");
            this.action.cancel(true);
            return;
        }
        this.stepBar.enableLoaderImage();
        this.navBar.lockControls();
        curStep.lockControls();
        curStep.updateResult(event);
    }
}

