/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class OverridingProperties {
    private final Properties properties;

    public OverridingProperties(String fName) throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/" + fName);
        if (in == null) {
            in = this.getClass().getResourceAsStream(fName);
        }
        this.properties = new Properties();
        this.properties.load(in);
        this.init();
    }

    public OverridingProperties(InputStream stream) throws IOException {
        this(stream, null);
        this.init();
    }

    public OverridingProperties(Properties props) {
        this.properties = new Properties(props);
        this.init();
    }

    public OverridingProperties(InputStream bundledConf, InputStream homeConf) throws IOException {
        Properties baseProps = new Properties();
        baseProps.load(bundledConf);
        try {
            if (homeConf != null) {
                Properties homeProps = new Properties(baseProps);
                homeProps.load(homeConf);
                baseProps = homeProps;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.properties = baseProps;
        this.init();
    }

    private void init() {
        this.overrideFromSystem();
    }

    private void overrideFromSystem() {
        for (Object nextKey : this.properties.keySet()) {
            if (!(nextKey instanceof String)) continue;
            String next = (String)nextKey;
            if (!System.getProperties().containsKey(next)) continue;
            this.properties.setProperty(next, System.getProperties().getProperty(next));
        }
    }

    public URL getDependentResource(String fname) {
        URL url = this.getClass().getResource("/" + fname);
        if (url == null) {
            url = this.getClass().getResource(fname);
        }
        return url;
    }

    public final String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public final Object setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    public final Properties properties() {
        return (Properties)this.properties.clone();
    }
}

