/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.digests.SHA224Digest;
import org.openecard.bouncycastle.crypto.digests.SHA256Digest;
import org.openecard.bouncycastle.crypto.digests.SHA384Digest;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import org.openecard.bouncycastle.pqc.crypto.mceliece.McEliecePointchevalCipher;
import org.openecard.bouncycastle.pqc.jcajce.provider.mceliece.McElieceCCA2KeysToParams;
import org.openecard.bouncycastle.pqc.jcajce.provider.util.AsymmetricHybridCipher;

public class McEliecePointchevalCipherSpi
extends AsymmetricHybridCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private McEliecePointchevalCipher cipher;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();

    protected McEliecePointchevalCipherSpi(Digest digest, McEliecePointchevalCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.buf = new ByteArrayOutputStream();
    }

    @Override
    public byte[] update(byte[] input, int inOff, int inLen) {
        this.buf.write(input, inOff, inLen);
        return new byte[0];
    }

    @Override
    public byte[] doFinal(byte[] input, int inOff, int inLen) throws BadPaddingException {
        this.update(input, inOff, inLen);
        byte[] data = this.buf.toByteArray();
        this.buf.reset();
        if (this.opMode == 1) {
            try {
                return this.cipher.messageEncrypt(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.opMode == 2) {
            try {
                return this.cipher.messageDecrypt(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected int encryptOutputSize(int inLen) {
        return 0;
    }

    @Override
    protected int decryptOutputSize(int inLen) {
        return 0;
    }

    @Override
    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param = McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)key);
        param = new ParametersWithRandom(param, sr);
        this.digest.reset();
        this.cipher.init(true, param);
    }

    @Override
    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.digest.reset();
        this.cipher.init(false, param);
    }

    @Override
    public String getName() {
        return "McEliecePointchevalCipher";
    }

    @Override
    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceCCA2KeyParameters mcElieceCCA2KeyParameters = key instanceof PublicKey ? (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.cipher.getKeySize(mcElieceCCA2KeyParameters);
    }

    public byte[] messageEncrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException {
        byte[] output = null;
        try {
            output = this.cipher.messageEncrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException {
        byte[] output = null;
        try {
            output = this.cipher.messageDecrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public static class McEliecePointcheval512
    extends McEliecePointchevalCipherSpi {
        public McEliecePointcheval512() {
            super(new SHA512Digest(), new McEliecePointchevalCipher());
        }
    }

    public static class McEliecePointcheval384
    extends McEliecePointchevalCipherSpi {
        public McEliecePointcheval384() {
            super(new SHA384Digest(), new McEliecePointchevalCipher());
        }
    }

    public static class McEliecePointcheval256
    extends McEliecePointchevalCipherSpi {
        public McEliecePointcheval256() {
            super(new SHA256Digest(), new McEliecePointchevalCipher());
        }
    }

    public static class McEliecePointcheval224
    extends McEliecePointchevalCipherSpi {
        public McEliecePointcheval224() {
            super(new SHA224Digest(), new McEliecePointchevalCipher());
        }
    }

    public static class McEliecePointcheval
    extends McEliecePointchevalCipherSpi {
        public McEliecePointcheval() {
            super(new SHA1Digest(), new McEliecePointchevalCipher());
        }
    }
}

