/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.DTLSProtocol;
import org.openecard.bouncycastle.crypto.tls.DTLSRecordLayer;
import org.openecard.bouncycastle.crypto.tls.DTLSReliableHandshake;
import org.openecard.bouncycastle.crypto.tls.DTLSTransport;
import org.openecard.bouncycastle.crypto.tls.DatagramTransport;
import org.openecard.bouncycastle.crypto.tls.NewSessionTicket;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsAuthentication;
import org.openecard.bouncycastle.crypto.tls.TlsClient;
import org.openecard.bouncycastle.crypto.tls.TlsClientContextImpl;
import org.openecard.bouncycastle.crypto.tls.TlsContext;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.util.Arrays;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(this.secureRandom);
        ClientHandshakeState state = new ClientHandshakeState();
        state.client = client;
        state.clientContext = new TlsClientContextImpl(this.secureRandom, securityParameters);
        client.init(state.clientContext);
        DTLSRecordLayer recordLayer = new DTLSRecordLayer(transport, state.clientContext, client, 22);
        try {
            return this.clientHandshake(state, recordLayer);
        }
        catch (TlsFatalAlert fatalAlert) {
            recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            recordLayer.fail((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, DTLSRecordLayer recordLayer) throws IOException {
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        DTLSReliableHandshake handshake = new DTLSReliableHandshake(state.clientContext, recordLayer);
        byte[] clientHelloBody = this.generateClientHello(state, state.client);
        handshake.sendMessage((short)1, clientHelloBody);
        DTLSReliableHandshake.Message serverMessage = handshake.receiveMessage();
        ProtocolVersion server_version = recordLayer.getDiscoveredPeerVersion();
        ProtocolVersion client_version = state.clientContext.getClientVersion();
        if (!server_version.isEqualOrEarlierVersionOf(client_version)) {
            throw new TlsFatalAlert(47);
        }
        state.clientContext.setServerVersion(server_version);
        state.client.notifyServerVersion(server_version);
        while (serverMessage.getType() == 3) {
            byte[] cookie = DTLSClientProtocol.parseHelloVerifyRequest(state.clientContext, serverMessage.getBody());
            byte[] patched = DTLSClientProtocol.patchClientHelloWithCookie(clientHelloBody, cookie);
            handshake.resetHandshakeMessagesDigest();
            handshake.sendMessage((short)1, patched);
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        this.processServerHello(state, serverMessage.getBody());
        serverMessage = handshake.receiveMessage();
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(state.selectedCipherSuite);
        securityParameters.compressionAlgorithm = state.selectedCompressionMethod;
        securityParameters.verifyDataLength = 12;
        handshake.notifyHelloComplete();
        if (serverMessage.getType() == 23) {
            this.processServerSupplementalData(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.client.processServerSupplementalData(null);
        }
        state.keyExchange = state.client.getKeyExchange();
        state.keyExchange.init(state.clientContext);
        if (serverMessage.getType() == 11) {
            this.processServerCertificate(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.keyExchange.skipServerCredentials();
        }
        if (serverMessage.getType() == 12) {
            this.processServerKeyExchange(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        } else {
            state.keyExchange.skipServerKeyExchange();
        }
        if (serverMessage.getType() == 13) {
            this.processCertificateRequest(state, serverMessage.getBody());
            serverMessage = handshake.receiveMessage();
        }
        if (serverMessage.getType() == 14) {
            if (serverMessage.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        Vector clientSupplementalData = state.client.getClientSupplementalData();
        if (clientSupplementalData != null) {
            byte[] supplementalDataBody = DTLSClientProtocol.generateSupplementalData(clientSupplementalData);
            handshake.sendMessage((short)23, supplementalDataBody);
        }
        if (state.certificateRequest != null) {
            state.clientCredentials = state.authentication.getClientCredentials(state.certificateRequest);
            Certificate clientCertificate = null;
            if (state.clientCredentials != null) {
                clientCertificate = state.clientCredentials.getCertificate();
            }
            if (clientCertificate == null) {
                clientCertificate = Certificate.EMPTY_CHAIN;
            }
            byte[] certificateBody = DTLSClientProtocol.generateCertificate(clientCertificate);
            handshake.sendMessage((short)11, certificateBody);
        }
        if (state.clientCredentials != null) {
            state.keyExchange.processClientCredentials(state.clientCredentials);
        } else {
            state.keyExchange.skipClientCredentials();
        }
        byte[] clientKeyExchangeBody = this.generateClientKeyExchange(state);
        handshake.sendMessage((short)16, clientKeyExchangeBody);
        TlsProtocol.establishMasterSecret(state.clientContext, state.keyExchange);
        if (state.clientCredentials instanceof TlsSignerCredentials) {
            TlsSignerCredentials signerCredentials = (TlsSignerCredentials)state.clientCredentials;
            byte[] md5andsha1 = handshake.getCurrentHash();
            byte[] signature = signerCredentials.generateCertificateSignature(md5andsha1);
            byte[] certificateVerifyBody = this.generateCertificateVerify(state, signature);
            handshake.sendMessage((short)15, certificateVerifyBody);
        }
        recordLayer.initPendingEpoch(state.client.getCipher());
        byte[] clientVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "client finished", handshake.getCurrentHash());
        handshake.sendMessage((short)20, clientVerifyData);
        if (state.expectSessionTicket) {
            serverMessage = handshake.receiveMessage();
            if (serverMessage.getType() == 4) {
                this.processNewSessionTicket(state, serverMessage.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(state.clientContext, "server finished", handshake.getCurrentHash());
        serverMessage = handshake.receiveMessage();
        if (serverMessage.getType() != 20) {
            throw new TlsFatalAlert(10);
        }
        this.processFinished(serverMessage.getBody(), expectedServerVerifyData);
        handshake.finish();
        state.client.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, byte[] signature) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeOpaque16(signature, buf);
        return buf.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state, TlsClient client) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ProtocolVersion client_version = client.getClientVersion();
        if (!client_version.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        state.clientContext.setClientVersion(client_version);
        TlsUtils.writeVersion(client_version, buf);
        buf.write(state.clientContext.getSecurityParameters().getClientRandom());
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        state.offeredCipherSuites = client.getCipherSuites();
        state.clientExtensions = client.getClientExtensions();
        boolean noRenegExt = state.clientExtensions == null || state.clientExtensions.get(TlsProtocol.EXT_RenegotiationInfo) == null;
        int count = state.offeredCipherSuites.length;
        if (noRenegExt) {
            ++count;
        }
        TlsUtils.writeUint16(2 * count, buf);
        TlsUtils.writeUint16Array(state.offeredCipherSuites, buf);
        if (noRenegExt) {
            TlsUtils.writeUint16(255, buf);
        }
        state.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8((short)state.offeredCompressionMethods.length, buf);
        TlsUtils.writeUint8Array(state.offeredCompressionMethods, buf);
        if (state.clientExtensions != null) {
            TlsProtocol.writeExtensions(buf, state.clientExtensions);
        }
        return buf.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        state.keyExchange.generateClientKeyExchange(buf);
        return buf.toByteArray();
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (state.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.certificateRequest = CertificateRequest.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.validateCertificateRequest(state.certificateRequest);
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Certificate serverCertificate = Certificate.parse(buf);
        TlsProtocol.assertEmpty(buf);
        state.keyExchange.processServerCertificate(serverCertificate);
        state.authentication = state.client.getAuthentication();
        state.authentication.notifyServerCertificate(serverCertificate);
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        SecurityParameters securityParameters = state.clientContext.getSecurityParameters();
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        if (!server_version.equals(state.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)buf);
        byte[] sessionID = TlsUtils.readOpaque8(buf);
        if (sessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySessionID(sessionID);
        state.selectedCipherSuite = TlsUtils.readUint16(buf);
        if (!TlsProtocol.arrayContains(state.offeredCipherSuites, state.selectedCipherSuite) || state.selectedCipherSuite == 0 || state.selectedCipherSuite == 255) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(state.selectedCipherSuite, (short)47);
        state.client.notifySelectedCipherSuite(state.selectedCipherSuite);
        state.selectedCompressionMethod = TlsUtils.readUint8(buf);
        if (!TlsProtocol.arrayContains(state.offeredCompressionMethods, state.selectedCompressionMethod)) {
            throw new TlsFatalAlert(47);
        }
        state.client.notifySelectedCompressionMethod(state.selectedCompressionMethod);
        Hashtable serverExtensions = TlsProtocol.readExtensions(buf);
        if (serverExtensions != null) {
            Enumeration e = serverExtensions.keys();
            while (e.hasMoreElements()) {
                Integer extType = (Integer)e.nextElement();
                if (extType.equals(TlsProtocol.EXT_RenegotiationInfo) || state.clientExtensions != null && state.clientExtensions.get(extType) != null) continue;
                throw new TlsFatalAlert(110);
            }
            byte[] renegExtValue = (byte[])serverExtensions.get(TlsProtocol.EXT_RenegotiationInfo);
            if (renegExtValue != null) {
                state.secure_renegotiation = true;
                if (!Arrays.constantTimeAreEqual(renegExtValue, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
            state.expectSessionTicket = serverExtensions.containsKey(TlsProtocol.EXT_SessionTicket);
        }
        state.client.notifySecureRenegotiation(state.secure_renegotiation);
        if (state.clientExtensions != null) {
            state.client.processServerExtensions(serverExtensions);
        }
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        state.keyExchange.processServerKeyExchange(buf);
        TlsProtocol.assertEmpty(buf);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        Vector serverSupplementalData = TlsProtocol.readSupplementalDataMessage(buf);
        state.client.processServerSupplementalData(serverSupplementalData);
    }

    protected static byte[] parseHelloVerifyRequest(TlsContext context, byte[] body) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body);
        ProtocolVersion server_version = TlsUtils.readVersion(buf);
        if (!server_version.equals(context.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        byte[] cookie = TlsUtils.readOpaque8(buf);
        TlsProtocol.assertEmpty(buf);
        return cookie;
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int sessionIDPos = 34;
        short sessionIDLength = TlsUtils.readUint8(clientHelloBody, sessionIDPos);
        int cookieLengthPos = sessionIDPos + 1 + sessionIDLength;
        int cookiePos = cookieLengthPos + 1;
        byte[] patched = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, patched, 0, cookieLengthPos);
        TlsUtils.writeUint8((short)cookie.length, patched, cookieLengthPos);
        System.arraycopy(cookie, 0, patched, cookiePos, cookie.length);
        System.arraycopy(clientHelloBody, cookiePos, patched, cookiePos + cookie.length, clientHelloBody.length - cookiePos);
        return patched;
    }

    protected static class ClientHandshakeState {
        TlsClient client = null;
        TlsClientContextImpl clientContext = null;
        int[] offeredCipherSuites = null;
        short[] offeredCompressionMethods = null;
        Hashtable clientExtensions = null;
        int selectedCipherSuite = -1;
        short selectedCompressionMethod = (short)-1;
        boolean secure_renegotiation = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsAuthentication authentication = null;
        CertificateRequest certificateRequest = null;
        TlsCredentials clientCredentials = null;

        protected ClientHandshakeState() {
        }
    }
}

