/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.richclient.gui.manage.AddonSelectionModel;
import org.openecard.richclient.gui.manage.core.PINAddon;
import org.openecard.richclient.gui.manage.core.SettingsAddon;

public class ManagementDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel selectionPanel;
    private JPanel contentPane;
    private JList<String> coreList;
    private JList<String> addonList;
    private JPanel addonPanel;
    private JLabel lastImage;

    public static void showDialog() {
        ManagementDialog dialog = new ManagementDialog();
        dialog.setVisible(true);
    }

    public ManagementDialog() {
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setIconImage(logo);
        this.setTitle("Open eCard Platform and Add-on Management");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(640, 420));
        this.setSize(730, 480);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.addonPanel = new JPanel(new BorderLayout(), true);
        this.contentPane.add((Component)this.addonPanel, "Center");
        this.selectionPanel = new JPanel();
        this.contentPane.add((Component)this.selectionPanel, "West");
        GridBagLayout selectionLayout = new GridBagLayout();
        selectionLayout.rowHeights = new int[]{0, 0, 0, 0};
        selectionLayout.columnWeights = new double[]{1.0};
        selectionLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        this.selectionPanel.setLayout(selectionLayout);
        this.createCoreList();
        this.createAddonList();
        this.setupCoreList();
        this.setupAddonList();
        this.setLocationRelativeTo(null);
    }

    public void setLogo(Image logo) {
        if (this.lastImage != null) {
            this.selectionPanel.remove(this.lastImage);
        }
        this.lastImage = new JLabel(new ImageIcon(logo));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 6, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 0;
        this.selectionPanel.add((Component)this.lastImage, labelConstraints);
        this.selectionPanel.revalidate();
        this.selectionPanel.repaint();
    }

    private void createCoreList() {
        JLabel label = new JLabel("Open eCard");
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 1;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.coreList = new JList();
        this.coreList.setFont(this.coreList.getFont().deriveFont(0));
        this.coreList.setSelectionMode(0);
        GridBagConstraints coreListConstraints = new GridBagConstraints();
        coreListConstraints.fill = 2;
        coreListConstraints.insets = new Insets(0, 5, 5, 10);
        coreListConstraints.anchor = 11;
        coreListConstraints.gridx = 0;
        coreListConstraints.gridy = 2;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.coreList.setModel(model);
        this.coreList.addListSelectionListener(model);
        this.addWindowListener(model);
        model.addElement("Proxy Settings", new SettingsAddon());
        model.addElement("PIN Management", new PINAddon());
        this.selectionPanel.add(this.coreList, coreListConstraints);
    }

    private void createAddonList() {
        JLabel label = new JLabel("Add-ons");
        label.setFont(label.getFont().deriveFont(1));
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.insets = new Insets(5, 0, 5, 10);
        labelConstraints.anchor = 11;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = 3;
        this.selectionPanel.add((Component)label, labelConstraints);
        this.addonList = new JList();
        this.addonList.setFont(this.addonList.getFont().deriveFont(0));
        this.addonList.setSelectionMode(0);
        GridBagConstraints addonListConstraints = new GridBagConstraints();
        addonListConstraints.insets = new Insets(0, 5, 0, 10);
        addonListConstraints.fill = 1;
        addonListConstraints.gridx = 0;
        addonListConstraints.gridy = 4;
        AddonSelectionModel model = new AddonSelectionModel(this, this.addonPanel);
        this.addonList.setModel(model);
        this.addonList.addListSelectionListener(model);
        this.addWindowListener(model);
        this.selectionPanel.add(this.addonList, addonListConstraints);
    }

    private void setupCoreList() {
        this.coreList.addListSelectionListener(new ClearSelectionListener(this.addonList));
        this.coreList.setSelectedIndex(0);
    }

    private void setupAddonList() {
        this.addonList.addListSelectionListener(new ClearSelectionListener(this.coreList));
    }

    private class ClearSelectionListener
    implements ListSelectionListener {
        private final JList otherList;

        public ClearSelectionListener(JList otherList) {
            this.otherList = otherList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof JComponent) {
                JComponent component = (JComponent)source;
                if (!e.getValueIsAdjusting() && component.hasFocus()) {
                    this.otherList.clearSelection();
                }
            }
        }
    }
}

