/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color color1;
    private Color color2;

    public GradientPanel() {
    }

    public GradientPanel(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    public GradientPanel(LayoutManager layout) {
        super(layout);
    }

    public GradientPanel(LayoutManager layout, Color color1, Color color2) {
        super(layout);
        this.color1 = color1;
        this.color2 = color2;
    }

    public GradientPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public GradientPanel(boolean isDoubleBuffered, Color color1, Color color2) {
        super(isDoubleBuffered);
        this.color1 = color1;
        this.color2 = color2;
    }

    public GradientPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public GradientPanel(LayoutManager layout, boolean isDoubleBuffered, Color color1, Color color2) {
        super(layout, isDoubleBuffered);
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.color1 == null) {
            this.color1 = Color.LIGHT_GRAY;
        }
        if (this.color2 == null) {
            this.color2 = Color.DARK_GRAY;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.color1, w, 0.0f, this.color2);
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, w, h);
        g2d.dispose();
        super.paintComponent(g);
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }
}

