/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

public class FileDescriptorByte {
    private final byte data;

    public FileDescriptorByte(byte data) {
        this.data = data;
    }

    private boolean isFD() {
        return (this.data >> 7 & 1) != 1;
    }

    public boolean shareable() {
        if (this.isFD()) {
            return (this.data >> 6 & 1) == 1;
        }
        return false;
    }

    public boolean isDF() {
        if (this.isFD()) {
            return (this.data & 0x38) == 56;
        }
        return false;
    }

    public boolean isWorkingEF() {
        if (this.isFD()) {
            return (this.data >> 3 & 7) == 0;
        }
        return false;
    }

    public boolean isInternalEF() {
        if (this.isFD()) {
            return (this.data >> 3 & 7) == 1;
        }
        return false;
    }

    public boolean isProprietaryEF() {
        if (this.isFD()) {
            byte val = (byte)(this.data >> 3 & 7);
            return val < 7 && val != 0 && val != 1;
        }
        return false;
    }

    public boolean isEF() {
        return this.isWorkingEF() || this.isInternalEF() || this.isProprietaryEF();
    }

    public boolean isUnknownFormat() {
        return this.isEF() && (this.data & 7) == 0;
    }

    public boolean isTransparent() {
        return this.isEF() && (this.data & 7) == 1;
    }

    public boolean isLinear() {
        byte lower;
        return this.isEF() && ((lower = (byte)(this.data & 7)) == 2 || lower == 3 || lower == 4 || lower == 5);
    }

    public boolean isCyclic() {
        byte lower;
        return this.isEF() && ((lower = (byte)(this.data & 7)) == 6 || lower == 7);
    }

    public boolean isDataObject() {
        byte lower;
        return this.isFD() && (this.data >> 3 & 7) == 7 && ((lower = (byte)(this.data & 7)) == 1 || lower == 2);
    }

    public String toString(String prefix) {
        StringBuilder b = new StringBuilder(4096);
        b.append(prefix);
        b.append("FileDescriptor-Byte: ");
        if (this.shareable()) {
            b.append("shareable ");
        }
        if (this.isDF()) {
            b.append("DF ");
        }
        if (this.isEF()) {
            b.append("EF ");
        }
        if (this.isInternalEF()) {
            b.append("internal ");
        }
        if (this.isWorkingEF()) {
            b.append("working ");
        }
        if (this.isProprietaryEF()) {
            b.append("proprietary ");
        }
        if (this.isUnknownFormat()) {
            b.append("unknown-format ");
        }
        if (this.isTransparent()) {
            b.append("transparent ");
        }
        if (this.isLinear()) {
            b.append("linear ");
        }
        if (this.isCyclic()) {
            b.append("cyclic ");
        }
        if (this.isDataObject()) {
            b.append("data-object ");
        }
        return b.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

