/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.openecard.bouncycastle.asn1.sec.SECNamedCurves;
import org.openecard.bouncycastle.asn1.x9.X9ECParameters;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.openecard.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.openecard.bouncycastle.crypto.params.ECDomainParameters;
import org.openecard.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.crypto.tls.NamedCurve;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.math.ec.ECCurve;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.bouncycastle.util.BigIntegers;
import org.openecard.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_elliptic_curves = Integers.valueOf(10);
    public static final Integer EXT_ec_point_formats = Integers.valueOf(11);
    private static final String[] curveNames = new String[]{"sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1"};

    public static void addSupportedEllipticCurvesExtension(Hashtable extensions, int[] namedCurves) throws IOException {
        extensions.put(EXT_elliptic_curves, TlsECCUtils.createSupportedEllipticCurvesExtension(namedCurves));
    }

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static int[] getSupportedEllipticCurvesExtension(Hashtable extensions) throws IOException {
        if (extensions == null) {
            return null;
        }
        byte[] extensionValue = (byte[])extensions.get(EXT_elliptic_curves);
        if (extensionValue == null) {
            return null;
        }
        return TlsECCUtils.readSupportedEllipticCurvesExtension(extensionValue);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        if (extensions == null) {
            return null;
        }
        byte[] extensionValue = (byte[])extensions.get(EXT_ec_point_formats);
        if (extensionValue == null) {
            return null;
        }
        return TlsECCUtils.readSupportedPointFormatsExtension(extensionValue);
    }

    public static byte[] createSupportedEllipticCurvesExtension(int[] namedCurves) throws IOException {
        if (namedCurves == null || namedCurves.length < 1) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint16(2 * namedCurves.length, buf);
        TlsUtils.writeUint16Array(namedCurves, buf);
        return buf.toByteArray();
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null) {
            ecPointFormats = new short[]{0};
        } else if (!TlsProtocol.arrayContains(ecPointFormats, (short)0)) {
            short[] tmp = new short[ecPointFormats.length + 1];
            System.arraycopy(ecPointFormats, 0, tmp, 0, ecPointFormats.length);
            tmp[ecPointFormats.length] = 0;
            ecPointFormats = tmp;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)ecPointFormats.length, buf);
        TlsUtils.writeUint8Array(ecPointFormats, buf);
        return buf.toByteArray();
    }

    public static int[] readSupportedEllipticCurvesExtension(byte[] extensionValue) throws IOException {
        if (extensionValue == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionValue);
        int length = TlsUtils.readUint16(buf);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] namedCurves = TlsUtils.readUint16Array(length / 2, buf);
        TlsProtocol.assertEmpty(buf);
        return namedCurves;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionValue) throws IOException {
        if (extensionValue == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionValue);
        short length = TlsUtils.readUint8(buf);
        if (length < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] ecPointFormats = TlsUtils.readUint8Array(length, buf);
        TlsProtocol.assertEmpty(buf);
        if (!TlsProtocol.arrayContains(ecPointFormats, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return ecPointFormats;
    }

    public static String getNameOfNamedCurve(int namedCurve) {
        return TlsECCUtils.isSupportedNamedCurve(namedCurve) ? curveNames[namedCurve - 1] : null;
    }

    public static ECDomainParameters getParametersForNamedCurve(int namedCurve) {
        String curveName = TlsECCUtils.getNameOfNamedCurve(namedCurve);
        if (curveName == null) {
            return null;
        }
        X9ECParameters ecP = SECNamedCurves.getByName(curveName);
        if (ecP == null) {
            return null;
        }
        return new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static boolean hasAnySupportedNamedCurves() {
        return curveNames.length > 0;
    }

    public static boolean containsECCCipherSuites(int[] cipherSuites) {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!TlsECCUtils.isECCCipherSuite(cipherSuites[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isECCCipherSuite(int cipherSuite) {
        switch (cipherSuite) {
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: {
                return true;
            }
        }
        return false;
    }

    public static boolean areOnSameCurve(ECDomainParameters a, ECDomainParameters b) {
        return a.getCurve().equals(b.getCurve()) && a.getG().equals(b.getG()) && a.getN().equals(b.getN()) && a.getH().equals(b.getH());
    }

    public static boolean isSupportedNamedCurve(int namedCurve) {
        return namedCurve > 0 && namedCurve <= curveNames.length;
    }

    public static boolean isCompressionPreferred(short[] ecPointFormats, short compressionFormat) {
        if (ecPointFormats == null) {
            return false;
        }
        for (int i = 0; i < ecPointFormats.length; ++i) {
            short ecPointFormat = ecPointFormats[i];
            if (ecPointFormat == 0) {
                return false;
            }
            if (ecPointFormat != compressionFormat) continue;
            return true;
        }
        return false;
    }

    public static byte[] serializeECFieldElement(int fieldSize, BigInteger x) throws IOException {
        int requiredLength = (fieldSize + 7) / 8;
        return BigIntegers.asUnsignedByteArray(requiredLength, x);
    }

    public static byte[] serializeECPoint(short[] ecPointFormats, ECPoint point) throws IOException {
        ECCurve curve = point.getCurve();
        boolean compressed = false;
        if (curve instanceof ECCurve.F2m) {
            compressed = TlsECCUtils.isCompressionPreferred(ecPointFormats, (short)2);
        } else if (curve instanceof ECCurve.Fp) {
            compressed = TlsECCUtils.isCompressionPreferred(ecPointFormats, (short)1);
        }
        return point.getEncoded(compressed);
    }

    public static byte[] serializeECPublicKey(short[] ecPointFormats, ECPublicKeyParameters keyParameters) throws IOException {
        return TlsECCUtils.serializeECPoint(ecPointFormats, keyParameters.getQ());
    }

    public static BigInteger deserializeECFieldElement(int fieldSize, byte[] encoding) throws IOException {
        int requiredLength = (fieldSize + 7) / 8;
        if (encoding.length != requiredLength) {
            throw new TlsFatalAlert(50);
        }
        return new BigInteger(1, encoding);
    }

    public static ECPoint deserializeECPoint(short[] ecPointFormats, ECCurve curve, byte[] encoding) throws IOException {
        return curve.decodePoint(encoding);
    }

    public static ECPublicKeyParameters deserializeECPublicKey(short[] ecPointFormats, ECDomainParameters curve_params, byte[] encoding) throws IOException {
        try {
            ECPoint Y = TlsECCUtils.deserializeECPoint(ecPointFormats, curve_params.getCurve(), encoding);
            return new ECPublicKeyParameters(Y, curve_params);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47);
        }
    }

    public static byte[] calculateECDHBasicAgreement(ECPublicKeyParameters publicKey, ECPrivateKeyParameters privateKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(basicAgreement.getFieldSize(), agreementValue);
    }

    public static AsymmetricCipherKeyPair generateECKeyPair(SecureRandom random, ECDomainParameters ecParams) {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keyGenerationParameters = new ECKeyGenerationParameters(ecParams, random);
        keyPairGenerator.init(keyGenerationParameters);
        return keyPairGenerator.generateKeyPair();
    }

    public static ECPublicKeyParameters validateECPublicKey(ECPublicKeyParameters key) throws IOException {
        return key;
    }

    public static int readECExponent(int fieldSize, InputStream input) throws IOException {
        int k;
        BigInteger K = TlsECCUtils.readECParameter(input);
        if (K.bitLength() < 32 && (k = K.intValue()) > 0 && k < fieldSize) {
            return k;
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readECFieldElement(int fieldSize, InputStream input) throws IOException {
        return TlsECCUtils.deserializeECFieldElement(fieldSize, TlsUtils.readOpaque8(input));
    }

    public static BigInteger readECParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque8(input));
    }

    public static ECDomainParameters readECParameters(int[] namedCurves, short[] ecPointFormats, InputStream input) throws IOException {
        try {
            short curveType = TlsUtils.readUint8(input);
            switch (curveType) {
                case 1: {
                    BigInteger prime_p = TlsECCUtils.readECParameter(input);
                    BigInteger a = TlsECCUtils.readECFieldElement(prime_p.bitLength(), input);
                    BigInteger b = TlsECCUtils.readECFieldElement(prime_p.bitLength(), input);
                    ECCurve.Fp curve = new ECCurve.Fp(prime_p, a, b);
                    ECPoint base = TlsECCUtils.deserializeECPoint(ecPointFormats, curve, TlsUtils.readOpaque8(input));
                    BigInteger order = TlsECCUtils.readECParameter(input);
                    BigInteger cofactor = TlsECCUtils.readECParameter(input);
                    return new ECDomainParameters(curve, base, order, cofactor);
                }
                case 2: {
                    ECCurve.F2m curve;
                    int m = TlsUtils.readUint16(input);
                    short basis = TlsUtils.readUint8(input);
                    switch (basis) {
                        case 1: {
                            int k = TlsECCUtils.readECExponent(m, input);
                            BigInteger a = TlsECCUtils.readECFieldElement(m, input);
                            BigInteger b = TlsECCUtils.readECFieldElement(m, input);
                            curve = new ECCurve.F2m(m, k, a, b);
                            break;
                        }
                        case 2: {
                            int k1 = TlsECCUtils.readECExponent(m, input);
                            int k2 = TlsECCUtils.readECExponent(m, input);
                            int k3 = TlsECCUtils.readECExponent(m, input);
                            BigInteger a = TlsECCUtils.readECFieldElement(m, input);
                            BigInteger b = TlsECCUtils.readECFieldElement(m, input);
                            curve = new ECCurve.F2m(m, k1, k2, k3, a, b);
                            break;
                        }
                        default: {
                            throw new TlsFatalAlert(47);
                        }
                    }
                    ECPoint base = TlsECCUtils.deserializeECPoint(ecPointFormats, curve, TlsUtils.readOpaque8(input));
                    BigInteger order = TlsECCUtils.readECParameter(input);
                    BigInteger cofactor = TlsECCUtils.readECParameter(input);
                    return new ECDomainParameters(curve, base, order, cofactor);
                }
                case 3: {
                    int namedCurve = TlsUtils.readUint16(input);
                    if (!NamedCurve.refersToASpecificNamedCurve(namedCurve)) {
                        throw new TlsFatalAlert(47);
                    }
                    if (!TlsProtocol.arrayContains(namedCurves, namedCurve)) {
                        throw new TlsFatalAlert(47);
                    }
                    return TlsECCUtils.getParametersForNamedCurve(namedCurve);
                }
            }
            throw new TlsFatalAlert(47);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47);
        }
    }

    public static void writeECExponent(int k, OutputStream output) throws IOException {
        BigInteger K = BigInteger.valueOf(k);
        TlsECCUtils.writeECParameter(K, output);
    }

    public static void writeECFieldElement(int fieldSize, BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECFieldElement(fieldSize, x), output);
    }

    public static void writeECParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque8(BigIntegers.asUnsignedByteArray(x), output);
    }

    public static void writeExplicitECParameters(short[] ecPointFormats, ECDomainParameters ecParameters, OutputStream output) throws IOException {
        ECCurve curve = ecParameters.getCurve();
        if (curve instanceof ECCurve.Fp) {
            TlsUtils.writeUint8((short)1, output);
            ECCurve.Fp fp = (ECCurve.Fp)curve;
            TlsECCUtils.writeECParameter(fp.getQ(), output);
        } else if (curve instanceof ECCurve.F2m) {
            TlsUtils.writeUint8((short)2, output);
            ECCurve.F2m f2m = (ECCurve.F2m)curve;
            TlsUtils.writeUint16(f2m.getM(), output);
            if (f2m.isTrinomial()) {
                TlsUtils.writeUint8((short)1, output);
                TlsECCUtils.writeECExponent(f2m.getK1(), output);
            } else {
                TlsUtils.writeUint8((short)2, output);
                TlsECCUtils.writeECExponent(f2m.getK1(), output);
                TlsECCUtils.writeECExponent(f2m.getK2(), output);
                TlsECCUtils.writeECExponent(f2m.getK3(), output);
            }
        } else {
            throw new IllegalArgumentException("'ecParameters' not a known curve type");
        }
        TlsECCUtils.writeECFieldElement(curve.getFieldSize(), curve.getA().toBigInteger(), output);
        TlsECCUtils.writeECFieldElement(curve.getFieldSize(), curve.getB().toBigInteger(), output);
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECPoint(ecPointFormats, ecParameters.getG()), output);
        TlsECCUtils.writeECParameter(ecParameters.getN(), output);
        TlsECCUtils.writeECParameter(ecParameters.getH(), output);
    }

    public static void writeNamedECParameters(int namedCurve, OutputStream output) throws IOException {
        if (!NamedCurve.refersToASpecificNamedCurve(namedCurve)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.writeUint16(namedCurve, output);
    }
}

