/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.modes;

import java.io.ByteArrayOutputStream;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.InvalidCipherTextException;
import org.openecard.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.openecard.bouncycastle.crypto.modes.AEADBlockCipher;
import org.openecard.bouncycastle.crypto.modes.SICBlockCipher;
import org.openecard.bouncycastle.crypto.params.AEADParameters;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.util.Arrays;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ByteArrayOutputStream associatedText = new ByteArrayOutputStream();
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = c.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters param = (AEADParameters)params;
            this.nonce = param.getNonce();
            this.initialAssociatedText = param.getAssociatedText();
            this.macSize = param.getMacSize() / 8;
            this.keyParam = param.getKey();
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV param = (ParametersWithIV)params;
            this.nonce = param.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            this.keyParam = param.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    @Override
    public void processAADByte(byte in) {
        this.associatedText.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.associatedText.write(in, inOff, len);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.data.write(in);
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.data.write(in, inOff, inLen);
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        byte[] text = this.data.toByteArray();
        byte[] enc = this.processPacket(text, 0, text.length);
        System.arraycopy(enc, 0, out, outOff, enc.length);
        this.reset();
        return enc.length;
    }

    @Override
    public void reset() {
        this.cipher.reset();
        this.associatedText.reset();
        this.data.reset();
    }

    @Override
    public byte[] getMac() {
        byte[] mac = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, mac, 0, mac.length);
        return mac;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return 0;
    }

    @Override
    public int getOutputSize(int len) {
        int totalData = len + this.data.size();
        if (this.forEncryption) {
            return totalData + this.macSize;
        }
        return totalData < this.macSize ? 0 : totalData - this.macSize;
    }

    public byte[] processPacket(byte[] in, int inOff, int inLen) throws IllegalStateException, InvalidCipherTextException {
        int index;
        byte[] output;
        int limitLen;
        if (this.keyParam == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n = this.nonce.length;
        int q = 15 - n;
        if (q < 4 && inLen >= (limitLen = 1 << 8 * q)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] iv = new byte[this.blockSize];
        iv[0] = (byte)(q - 1 & 7);
        System.arraycopy(this.nonce, 0, iv, 1, this.nonce.length);
        SICBlockCipher ctrCipher = new SICBlockCipher(this.cipher);
        ctrCipher.init(this.forEncryption, new ParametersWithIV(this.keyParam, iv));
        int outOff = 0;
        if (this.forEncryption) {
            output = new byte[inLen + this.macSize];
            this.calculateMac(in, inOff, inLen, this.macBlock);
            ctrCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (index = inOff; index < inLen - this.blockSize; index += this.blockSize) {
                ctrCipher.processBlock(in, index, output, outOff);
                outOff += this.blockSize;
            }
            byte[] block = new byte[this.blockSize];
            System.arraycopy(in, index, block, 0, inLen - index);
            ctrCipher.processBlock(block, 0, block, 0);
            System.arraycopy(block, 0, output, outOff, inLen - index);
            System.arraycopy(this.macBlock, 0, output, outOff += inLen - index, output.length - outOff);
        } else {
            output = new byte[inLen - this.macSize];
            System.arraycopy(in, inOff + inLen - this.macSize, this.macBlock, 0, this.macSize);
            ctrCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i = this.macSize; i != this.macBlock.length; ++i) {
                this.macBlock[i] = 0;
            }
            while (outOff < output.length - this.blockSize) {
                ctrCipher.processBlock(in, index, output, outOff);
                outOff += this.blockSize;
                index += this.blockSize;
            }
            byte[] block = new byte[this.blockSize];
            System.arraycopy(in, index, block, 0, output.length - outOff);
            ctrCipher.processBlock(block, 0, block, 0);
            System.arraycopy(block, 0, output, outOff, output.length - outOff);
            byte[] calculatedMacBlock = new byte[this.blockSize];
            this.calculateMac(output, 0, output.length, calculatedMacBlock);
            if (!Arrays.constantTimeAreEqual(this.macBlock, calculatedMacBlock)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return output;
    }

    private int calculateMac(byte[] data, int dataOff, int dataLen, byte[] macBlock) {
        CBCBlockCipherMac cMac = new CBCBlockCipherMac(this.cipher, this.macSize * 8);
        cMac.init(this.keyParam);
        byte[] b0 = new byte[16];
        if (this.hasAssociatedText()) {
            b0[0] = (byte)(b0[0] | 0x40);
        }
        b0[0] = (byte)(b0[0] | ((cMac.getMacSize() - 2) / 2 & 7) << 3);
        b0[0] = (byte)(b0[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, b0, 1, this.nonce.length);
        int q = dataLen;
        int count = 1;
        while (q > 0) {
            b0[b0.length - count] = (byte)(q & 0xFF);
            q >>>= 8;
            ++count;
        }
        cMac.update(b0, 0, b0.length);
        if (this.hasAssociatedText()) {
            int extra;
            int textLength = this.getAssociatedTextLength();
            if (textLength < 65280) {
                cMac.update((byte)(textLength >> 8));
                cMac.update((byte)textLength);
                extra = 2;
            } else {
                cMac.update((byte)-1);
                cMac.update((byte)-2);
                cMac.update((byte)(textLength >> 24));
                cMac.update((byte)(textLength >> 16));
                cMac.update((byte)(textLength >> 8));
                cMac.update((byte)textLength);
                extra = 6;
            }
            if (this.initialAssociatedText != null) {
                cMac.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.associatedText.size() > 0) {
                byte[] tmp = this.associatedText.toByteArray();
                cMac.update(tmp, 0, tmp.length);
            }
            if ((extra = (extra + textLength) % 16) != 0) {
                for (int i = extra; i != 16; ++i) {
                    cMac.update((byte)0);
                }
            }
        }
        cMac.update(data, dataOff, dataLen);
        return cMac.doFinal(macBlock, 0);
    }

    private int getAssociatedTextLength() {
        return this.associatedText.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }
}

