/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.ec;

import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.ec.ECDecryptor;
import org.openecard.bouncycastle.crypto.ec.ECPair;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint tmp = pair.getX().multiply(this.key.getD());
        return pair.getY().add(tmp.negate());
    }
}

