/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.Map;
import java.util.Set;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.gui.StepResult;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;

public class InsertCardStepAction
extends StepAction {
    private String cardType;
    private ConnectionHandleType response;
    private CardStateMap cardStates;

    public InsertCardStepAction(String stepName, CardStateMap cardStates, String cardType) {
        super(stepName);
        this.cardStates = cardStates;
        this.cardType = cardType;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        Set<CardStateEntry> entries;
        ConnectionHandleType conHandle = new ConnectionHandleType();
        ConnectionHandleType.RecognitionInfo recInfo = new ConnectionHandleType.RecognitionInfo();
        recInfo.setCardType(this.cardType);
        conHandle.setRecognitionInfo(recInfo);
        do {
            entries = this.cardStates.getMatchingEntries(conHandle);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        } while (entries.size() < 1);
        this.response = entries.iterator().next().handleCopy();
        return new StepActionResult(StepActionResultStatus.NEXT);
    }

    public ConnectionHandleType getResponse() {
        return this.response;
    }
}

