/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.interceptor;

import java.io.IOException;
import java.util.Locale;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.impl.EnglishReasonPhraseCatalog;
import org.openecard.apache.http.message.BasicStatusLine;
import org.openecard.apache.http.protocol.HttpContext;

public class StatusLineResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse hr, HttpContext hc) throws HttpException, IOException {
        StatusLine statusLine = hr.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        Locale locale = hr.getLocale();
        String reason = statusLine.getReasonPhrase();
        reason = reason != null ? reason : StatusLineResponseInterceptor.reasonForCode(statusCode, locale);
        hr.setStatusLine(new BasicStatusLine(statusLine.getProtocolVersion(), statusCode, reason));
    }

    private static String reasonForCode(int code, Locale locale) {
        locale = locale != null ? locale : Locale.ENGLISH;
        String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(code, locale);
        return reason != null ? reason : "Extension Code";
    }
}

