/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler.common;

import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.RequestLine;
import org.openecard.apache.http.entity.BasicHttpEntity;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.control.ControlException;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.common.Http11Response;
import org.openecard.control.binding.http.common.MimeType;
import org.openecard.control.binding.http.handler.ControlCommonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandler
extends ControlCommonHandler {
    private static final Logger _logger = LoggerFactory.getLogger(FileHandler.class);
    private DocumentRoot documentRoot;

    public FileHandler(DocumentRoot documentRoot) {
        super("/*");
        this.documentRoot = documentRoot;
    }

    @Override
    public HttpResponse handle(HttpRequest httpRequest) throws ControlException, Exception {
        Http11Response httpResponse = new Http11Response(404);
        RequestLine requestLine = httpRequest.getRequestLine();
        if (requestLine.getMethod().equals("GET")) {
            URI requestURI = URI.create(requestLine.getUri());
            URL filePath = this.documentRoot.getFile(URLDecoder.decode(requestURI.getPath(), "UTF-8"));
            if (filePath != null) {
                _logger.debug("Handle file request");
                this.handleFile(httpResponse, filePath);
            } else {
                _logger.debug("The DocumentRoot does not contain the URI: {}", (Object)requestURI.getPath());
            }
        } else {
            httpResponse.setStatusCode(405);
        }
        return httpResponse;
    }

    private void handleFile(Http11Response httpResponse, URL file) throws Exception {
        String fileName = file.toString();
        String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        MimeType mimeType = MimeType.fromFilenameExtension(fileExtension);
        String typeName = mimeType != null ? mimeType.getMimeType() : MimeType.TEXT_PLAIN.getMimeType();
        httpResponse.setStatusCode(200);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent(file.openStream());
        entity.setContentType(ContentType.create(typeName, "UTF-8").toString());
        httpResponse.setEntity(entity);
    }
}

