/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import oasis.names.tc.dss._1_0.core.schema.InternationalStringType;
import oasis.names.tc.dss._1_0.core.schema.Result;

public abstract class ECardException
extends Exception {
    private Implementation impl;

    protected final void setImpl(Implementation impl) {
        this.impl = impl;
    }

    public static <E extends ECardException> E makeException(E e, String major, String minor, String msg) {
        Implementation i = new Implementation(major, minor, msg);
        e.setImpl(i);
        return e;
    }

    public static <E extends ECardException> E makeException(E e, String minor, String msg) {
        return ECardException.makeException(e, "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", minor, msg);
    }

    public static <E extends ECardException> E makeException(E e, String msg) {
        return ECardException.makeException(e, "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError", msg);
    }

    public static <E extends ECardException> E makeException(E e, Result r) {
        Implementation i = new Implementation(r);
        e.setImpl(i);
        return e;
    }

    public static <E extends ECardException> E makeException(E e, Throwable t, String major, String minor, String msg) {
        Implementation i = new Implementation(t, major, minor, msg);
        e.setImpl(i);
        return e;
    }

    public static <E extends ECardException> E makeException(E e, Throwable t, String minor, String msg) {
        return ECardException.makeException(e, t, "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error", minor, msg);
    }

    public static <E extends ECardException> E makeException(E e, Throwable t, String msg) {
        return ECardException.makeException(e, t, "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError", msg);
    }

    public static <E extends ECardException> E makeException(E e, Throwable t) {
        return ECardException.makeException(e, t, t.getMessage());
    }

    public final String getResultMajor() {
        return this.impl.resultMajor;
    }

    public final String getResultMinor() {
        return this.impl.resultMinor;
    }

    public final String getResultMessage() {
        return this.impl.getMessage();
    }

    public final Result getResult() {
        Result r = new Result();
        r.setResultMajor(this.getResultMajor());
        r.setResultMinor(this.getResultMinor());
        InternationalStringType s = new InternationalStringType();
        s.setLang("en");
        s.setValue(this.getResultMessage());
        r.setResultMessage(s);
        return r;
    }

    @Override
    public final String getMessage() {
        String minor = this.getResultMinor();
        return (minor == null ? "" : minor + " ==> ") + this.getResultMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public Throwable getCause() {
        return this.impl.getCause();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.impl.getStackTrace();
    }

    @Override
    public void printStackTrace() {
        this.impl.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.impl.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.impl.printStackTrace(s);
    }

    public static class Implementation
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String resultMajor;
        private String resultMinor;

        private Implementation(Result r) {
            super(r.getResultMessage() != null ? r.getResultMessage().getValue() : "Unknown eCard exception occurred.");
            this.resultMajor = r.getResultMajor();
            this.resultMinor = r.getResultMinor() != null ? r.getResultMinor() : "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError";
        }

        private Implementation(String resultMajor, String resultMinor, String resultMessage) {
            super(resultMessage);
            this.resultMajor = resultMajor;
            this.resultMinor = resultMinor;
        }

        private Implementation(Throwable cause, String resultMajor, String resultMinor, String resultMessage) {
            super(resultMessage, cause);
            this.resultMajor = resultMajor;
            this.resultMinor = resultMinor;
        }
    }
}

