/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.ocsp;

import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.openecard.bouncycastle.asn1.ASN1InputStream;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.ocsp.ResponderID;
import org.openecard.bouncycastle.asn1.x500.X500Name;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.ocsp.OCSPException;
import org.openecard.bouncycastle.ocsp.OCSPUtil;

public class RespID {
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Principal name) {
        this.id = new ResponderID(X500Name.getInstance(name.getEncoded()));
    }

    public RespID(PublicKey key) throws OCSPException {
        try {
            MessageDigest digest = OCSPUtil.createDigestInstance("SHA1", null);
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.id = new ResponderID(keyHash);
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

