/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.openecard.gui.FileDialog;
import org.openecard.gui.file.FileDialogResult;
import org.openecard.gui.file.FileFilter;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.gui.swing.file.SwingFileFilterWrapper;

public class SwingFileDialog
implements FileDialog {
    private final JFileChooser dialog = new JFileChooser(){

        @Override
        protected JDialog createDialog(Component parent) {
            JDialog dialog = super.createDialog(parent);
            dialog.setIconImage(GUIDefaults.getImage("Frame.icon", 45, 45).getImage());
            return dialog;
        }
    };

    public SwingFileDialog() {
        this.dialog.setPreferredSize(new Dimension(800, 490));
    }

    @Override
    public void setTitle(String title) {
        this.dialog.setDialogTitle(title);
    }

    @Override
    public void setCurrentDirectory(File currentDir) {
        this.dialog.setCurrentDirectory(currentDir);
    }

    @Override
    public void setSelectedFiles(List<File> files) {
        this.dialog.setSelectedFiles((File[])files.toArray());
    }

    @Override
    public void setSelectedFiles(File ... files) {
        this.dialog.setSelectedFiles(files);
    }

    @Override
    public void clearSelectedFiles() {
        this.dialog.setSelectedFile(new File(""));
    }

    @Override
    public void addFileFilter(FileFilter filter) {
        this.dialog.setFileFilter(new SwingFileFilterWrapper(filter));
    }

    @Override
    public void clearFileFilters() {
        this.dialog.resetChoosableFileFilters();
    }

    @Override
    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.dialog.setFileHidingEnabled(!showHiddenFiles);
    }

    @Override
    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.dialog.setMultiSelectionEnabled(multiSelectionEnabled);
    }

    @Override
    public void setFolderSelectable(boolean folderSelectable) {
        int mode = folderSelectable ? 2 : 0;
        this.dialog.setFileSelectionMode(mode);
    }

    @Override
    public FileDialogResult showOpen() {
        int resultCode = this.dialog.showOpenDialog(null);
        FileDialogResult result = this.buildResult(resultCode);
        return result;
    }

    @Override
    public FileDialogResult showSave() {
        int resultCode = this.dialog.showSaveDialog(null);
        FileDialogResult result = this.buildResult(resultCode);
        return result;
    }

    @Override
    public FileDialogResult show(String approveButtonText) {
        int resultCode = this.dialog.showDialog(null, approveButtonText);
        FileDialogResult result = this.buildResult(resultCode);
        return result;
    }

    private FileDialogResult buildResult(int resultCode) {
        FileDialogResult result;
        if (resultCode == 0) {
            File[] selectedFiles = this.dialog.getSelectedFiles();
            if (selectedFiles.length == 0) {
                selectedFiles = new File[]{this.dialog.getSelectedFile()};
            }
            result = new FileDialogResult(Arrays.asList(selectedFiles));
        } else {
            result = new FileDialogResult();
        }
        return result;
    }
}

