/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.openecard.common.I18n;
import org.openecard.common.Version;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(AboutDialog.class);
    private static final long serialVersionUID = 1L;
    private final transient I18n lang = I18n.getTranslation("about");

    public AboutDialog() {
        this.setupUI();
    }

    public static void showDialog() {
        AboutDialog dialog = new AboutDialog();
        dialog.setVisible(true);
    }

    private void setupUI() {
        Image logo = GraphicsUtil.createImage(OecLogoBgWhite.class, 147, 147);
        this.setSize(730, 480);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(Color.white);
        JTextPane txtpnHeading = new JTextPane();
        txtpnHeading.setFont(new Font("SansSerif", 1, 20));
        txtpnHeading.setEditable(false);
        txtpnHeading.setText(this.lang.translationForKey("about.heading", new Object[0]));
        txtpnHeading.setBounds(12, 12, 692, 30);
        this.getContentPane().add(txtpnHeading);
        JTextPane txtpnVersion = new JTextPane();
        txtpnVersion.setFont(new Font("SansSerif", 0, 9));
        txtpnVersion.setEditable(false);
        txtpnVersion.setText(this.lang.translationForKey("about.version", Version.getVersion()));
        txtpnVersion.setBounds(12, 54, 692, 18);
        this.getContentPane().add(txtpnVersion);
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        label.setIcon(new ImageIcon(logo));
        label.setBounds(12, 84, 155, 320);
        this.getContentPane().add(label);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(185, 84, 529, 320);
        tabbedPane.setBackground(Color.white);
        tabbedPane.addTab(this.lang.translationForKey("about.tab.about", new Object[0]), this.createTabContent("about"));
        tabbedPane.addTab(this.lang.translationForKey("about.tab.feedback", new Object[0]), this.createTabContent("feedback"));
        tabbedPane.addTab(this.lang.translationForKey("about.tab.join", new Object[0]), this.createTabContent("join"));
        tabbedPane.addTab(this.lang.translationForKey("about.tab.license", new Object[0]), this.createTabContent("gpl-v3"));
        this.getContentPane().add(tabbedPane);
        JButton btnClose = new JButton(this.lang.translationForKey("about.button.close", new Object[0]));
        btnClose.setBounds(587, 416, 117, 25);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.getContentPane().add(btnClose);
        this.setIconImage(logo);
        this.setTitle(this.lang.translationForKey("about.title", new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private JPanel createTabContent(String resourceName) {
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setEditorKit(kit);
        editorPane.setDocument(doc);
        try {
            URL url = this.lang.translationForFile(resourceName, "html");
            editorPane.setPage(url);
        }
        catch (IOException ex) {
            editorPane.setText("Page not found.");
        }
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AboutDialog.this.openUrl(e);
            }
        });
        JScrollPane scrollPane = new JScrollPane(editorPane);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void openUrl(HyperlinkEvent event) {
        HyperlinkEvent.EventType type = event.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            String url = event.getURL().toExternalForm();
            try {
                boolean browserOpened = false;
                URI uri = new URI(url);
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(uri);
                        browserOpened = true;
                    }
                    catch (IOException ex) {
                        logger.debug(ex.getMessage(), ex);
                    }
                }
                if (!browserOpened) {
                    ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                    try {
                        pb.start();
                    }
                    catch (IOException ex) {
                        logger.debug(ex.getMessage(), ex);
                    }
                }
            }
            catch (URISyntaxException ex) {
                logger.debug(ex.getMessage(), ex);
            }
        }
    }
}

