/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.openecard.common.enums.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventFilter;
import org.openecard.event.EventManager;

public class Dispatcher {
    private final EventManager manager;
    private final Semaphore guard;
    private final ConcurrentHashMap<EventCallback, ArrayList<EventFilter>> eventFilter;

    public Dispatcher(EventManager manager) {
        this.manager = manager;
        this.guard = new Semaphore(1);
        this.eventFilter = new ConcurrentHashMap();
    }

    public synchronized EventCallback add(EventCallback cb) {
        this.add(cb, new EventTypeFilter(new EventType[0]));
        return cb;
    }

    public synchronized EventCallback add(EventCallback cb, EventType ... eventTypes) {
        this.add(cb, new EventTypeFilter(eventTypes));
        return cb;
    }

    public synchronized EventCallback add(EventCallback cb, EventFilter filter) {
        try {
            this.guard.acquire();
            if (!this.eventFilter.containsKey(cb)) {
                this.eventFilter.put(cb, new ArrayList());
            }
            this.eventFilter.get(cb).add(filter);
            this.guard.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return cb;
    }

    public synchronized EventCallback del(EventCallback cb) {
        try {
            this.guard.acquire();
            if (this.eventFilter.containsKey(cb)) {
                this.eventFilter.remove(cb);
            }
            this.guard.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return cb;
    }

    public void notify(EventType t, Object o) {
        try {
            this.guard.acquire();
            block2: for (Map.Entry<EventCallback, ArrayList<EventFilter>> entry : this.eventFilter.entrySet()) {
                EventCallback cb = entry.getKey();
                for (EventFilter filter : entry.getValue()) {
                    if (!filter.matches(t, o)) continue;
                    this.fork(cb, t, o);
                    continue block2;
                }
            }
            this.guard.release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<?> fork(EventCallback cb, EventType t, Object o) {
        Future<?> f = this.manager.threadPool.submit(new EventRunner(cb, t, o));
        return f;
    }

    private static class EventRunner
    implements Runnable {
        EventCallback cb;
        EventType t;
        Object o;

        public EventRunner(EventCallback cb, EventType t, Object o) {
            this.cb = cb;
            this.t = t;
            this.o = o;
        }

        @Override
        public void run() {
            this.cb.signalEvent(this.t, this.o);
        }
    }

    private static class EventTypeFilter
    implements EventFilter {
        private ArrayList<EventType> eventType;

        public EventTypeFilter(EventType ... eventType) {
            this.eventType = eventType.length == 0 ? new ArrayList<EventType>(Arrays.asList(EventType.values())) : new ArrayList<EventType>(Arrays.asList(eventType));
        }

        @Override
        public boolean matches(EventType t, Object o) {
            for (EventType next : this.eventType) {
                if (!t.equals((Object)next)) continue;
                return true;
            }
            return false;
        }
    }
}

