/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.DERBitString;

public class SubjectPublicKeyInfo {
    private String algorithm;
    private byte[] subjectPublicKey;

    public SubjectPublicKeyInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Sequence wrong size for SubjectPublicKeyInfo");
        }
        this.algorithm = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0)).toString();
        this.subjectPublicKey = DERBitString.getInstance(seq.getObjectAt(1)).getBytes();
    }

    public static SubjectPublicKeyInfo getInstance(Object obj) {
        if (obj == null || obj instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SubjectPublicKeyInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass().getName());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSubjectPublicKey() {
        return this.subjectPublicKey;
    }
}

