/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state.cif;

import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDMarkerType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;
import org.openecard.common.sal.state.cif.DIDInfoWrapper;
import org.openecard.common.sal.state.cif.DataSetInfoWrapper;
import org.openecard.common.util.ByteArrayWrapper;

public class CardInfoWrapper {
    private final CardInfoType cif;
    private Map<ByteArrayWrapper, CardApplicationWrapper> cardApplications = new HashMap<ByteArrayWrapper, CardApplicationWrapper>();
    List<byte[]> cardApplicationNames = new ArrayList<byte[]>();

    public CardInfoWrapper(CardInfoType cif) {
        this.cif = cif;
    }

    public String getCardType() {
        return this.cif.getCardType().getObjectIdentifier();
    }

    public byte[] getImplicitlySelectedApplication() {
        return this.cif.getApplicationCapabilities().getImplicitlySelectedApplication();
    }

    public Map<ByteArrayWrapper, CardApplicationWrapper> getCardApplications() {
        if (this.cardApplications.isEmpty()) {
            for (CardApplicationType cardApplication : this.cif.getApplicationCapabilities().getCardApplication()) {
                this.cardApplications.put(new ByteArrayWrapper(cardApplication.getApplicationIdentifier()), new CardApplicationWrapper(cardApplication));
            }
        }
        return this.cardApplications;
    }

    public DIDInfoType getDIDInfo(String didName, byte[] applicationIdentifier) {
        CardApplicationWrapper application = this.getCardApplications().get(new ByteArrayWrapper(applicationIdentifier));
        if (application == null) {
            return null;
        }
        DIDInfoWrapper didInfo = application.getDIDInfo(didName);
        if (didInfo == null) {
            return null;
        }
        return didInfo.getDIDInfo();
    }

    public DataSetNameListType getDataSetNameList(byte[] cardApplication) {
        CardApplicationWrapper wrapper = this.cardApplications.get(new ByteArrayWrapper(cardApplication));
        if (wrapper == null) {
            return null;
        }
        return wrapper.getDataSetNameList();
    }

    public DataSetInfoType getDataSet(String dataSetName, byte[] applicationIdentifier) {
        CardApplicationWrapper application = this.cardApplications.get(new ByteArrayWrapper(applicationIdentifier));
        if (application == null) {
            return null;
        }
        DataSetInfoWrapper dataSet = application.getDataSetInfo(dataSetName);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getDataSetInfo();
    }

    public CardApplicationWrapper getCardApplication(byte[] applicationIdentifier) {
        return this.getCardApplications().get(new ByteArrayWrapper(applicationIdentifier));
    }

    public DIDStructureType getDIDStructure(String didName, byte[] cardApplication) {
        DIDInfoType didInfo = this.getDIDInfo(didName, cardApplication);
        if (didInfo == null) {
            return null;
        }
        DIDStructureType didStructure = new DIDStructureType();
        didStructure.setDIDName(didInfo.getDifferentialIdentity().getDIDName());
        didStructure.setDIDScope(didInfo.getDifferentialIdentity().getDIDScope());
        DIDMarkerType didMarker = didInfo.getDifferentialIdentity().getDIDMarker();
        if (didMarker.getCAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCAMarker());
        } else if (didMarker.getCryptoMarker() != null) {
            didStructure.setDIDMarker(didMarker.getCryptoMarker());
        } else if (didMarker.getEACMarker() != null) {
            didStructure.setDIDMarker(didMarker.getEACMarker());
        } else if (didMarker.getMutualAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getMutualAuthMarker());
        } else if (didMarker.getPACEMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPACEMarker());
        } else if (didMarker.getPinCompareMarker() != null) {
            didStructure.setDIDMarker(didMarker.getPinCompareMarker());
        } else if (didMarker.getRIMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRIMarker());
        } else if (didMarker.getRSAAuthMarker() != null) {
            didStructure.setDIDMarker(didMarker.getRSAAuthMarker());
        } else if (didMarker.getTAMarker() != null) {
            didStructure.setDIDMarker(didMarker.getTAMarker());
        }
        didStructure.setDIDQualifier(didInfo.getDifferentialIdentity().getDIDQualifier());
        return didStructure;
    }

    public List<byte[]> getCardApplicationNameList() {
        if (this.cardApplicationNames.isEmpty()) {
            for (CardApplicationType cardApplication : this.cif.getApplicationCapabilities().getCardApplication()) {
                this.cardApplicationNames.add(cardApplication.getApplicationIdentifier());
            }
        }
        return this.cardApplicationNames;
    }
}

