/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg;

import java.io.IOException;
import org.openecard.bouncycastle.bcpg.BCPGInputStream;
import org.openecard.bouncycastle.bcpg.BCPGOutputStream;
import org.openecard.bouncycastle.bcpg.ContainedPacket;
import org.openecard.bouncycastle.util.Strings;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        this.idData = in.readAll();
    }

    public UserIDPacket(String id) {
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(13, this.idData, true);
    }
}

