/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.recognition.staticrepo;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACD;
import iso.std.iso_iec._24727.tech.schema.GetCardInfoOrACDResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.WSHelper;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LocalCifRepo
implements org.openecard.ws.GetCardInfoOrACD {
    private final HashMap<String, CardInfoType> cifs = new HashMap();

    public LocalCifRepo(WSMarshaller m) throws IOException, WSMarshallerException, SAXException {
        String[] files;
        InputStream propStream = LocalCifRepo.getStream("repo-config.properties");
        Properties conf = new Properties();
        conf.load(propStream);
        String fileNames = conf.getProperty("cifFiles");
        for (String next : files = fileNames.split(",")) {
            InputStream cifStream = LocalCifRepo.getStream(next);
            Document cifDoc = m.str2doc(cifStream);
            CardInfoType cif = (CardInfoType)m.unmarshal(cifDoc);
            String cardType = cif.getCardType().getObjectIdentifier();
            this.cifs.put(cardType, cif);
        }
    }

    private static InputStream getStream(String res) throws FileNotFoundException {
        String prefix = "cif-repo/";
        InputStream s = LocalCifRepo.class.getResourceAsStream(prefix + res);
        if (s == null) {
            s = LocalCifRepo.class.getResourceAsStream("/" + prefix + res);
        }
        if (s == null) {
            throw new FileNotFoundException("Unable to load file " + res + ".");
        }
        return s;
    }

    @Override
    public GetCardInfoOrACDResponse getCardInfoOrACD(GetCardInfoOrACD parameters) {
        List<String> cardTypes = parameters.getCardTypeIdentifier();
        ArrayList<CardInfoType> cifsResult = new ArrayList<CardInfoType>(cardTypes.size());
        Result result = WSHelper.makeResultOK();
        if ("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getSpecifiedFile".equals(parameters.getAction())) {
            ArrayList<String> missingTypes = new ArrayList<String>();
            for (String cardType : cardTypes) {
                CardInfoType cif = this.cifs.get(cardType);
                if (cif == null) {
                    missingTypes.add(cardType);
                    continue;
                }
                cifsResult.add(cif);
            }
            if (!missingTypes.isEmpty()) {
                StringBuilder error = new StringBuilder("The following card types could not be found:");
                for (String type : missingTypes) {
                    error.append("\n  ").append(type);
                }
                result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#unknownCardType", error.toString());
            }
        } else if ("http://www.bsi.bund.de/ecard/api/1.1/cardinfo/action#getOtherFiles".equals(parameters.getAction())) {
            HashMap<String, CardInfoType> cifsTmp = new HashMap<String, CardInfoType>();
            cifsTmp.putAll(this.cifs);
            for (String cardType : cardTypes) {
                cifsTmp.remove(cardType);
            }
            cifsResult.addAll(cifsTmp.values());
        } else {
            result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", "Given action is unsupported.");
        }
        GetCardInfoOrACDResponse res = (GetCardInfoOrACDResponse)WSHelper.makeResponse(GetCardInfoOrACDResponse.class, result);
        res.getCardInfoOrCapabilityInfo().addAll(cifsResult);
        return res;
    }
}

