/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import java.math.BigInteger;
import org.openecard.bouncycastle.asn1.ASN1Integer;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.x9.X9ECParameters;
import org.openecard.bouncycastle.jce.spec.ECParameterSpec;
import org.openecard.bouncycastle.math.ec.ECCurve;
import org.openecard.crypto.common.asn1.eac.AlgorithmIdentifier;
import org.openecard.crypto.common.asn1.eac.DomainParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitDomainParameters
extends DomainParameters {
    private static final Logger _logger = LoggerFactory.getLogger(ExplicitDomainParameters.class);
    public static final String dhpublicnumber = "1.2.840.10046.2.1";
    public static final String ecPublicKey = "1.2.840.10045.2.1";

    public ExplicitDomainParameters(AlgorithmIdentifier ai) {
        String oid = ai.getObjectIdentifier();
        if (oid.equals(dhpublicnumber)) {
            this.loadDHParameter((ASN1Sequence)ai.getParameters());
        } else if (oid.equals(ecPublicKey)) {
            this.loadECDHParameter((ASN1Sequence)ai.getParameters());
        } else {
            throw new IllegalArgumentException("Cannot parse explicit domain parameters");
        }
    }

    private void loadECDHParameter(ASN1Sequence seq) {
        ASN1Integer order = (ASN1Integer)seq.getObjectAt(4);
        ASN1Integer cofactor = (ASN1Integer)seq.getObjectAt(5);
        try {
            BigInteger r = order.getValue();
            BigInteger f = cofactor.getValue();
            X9ECParameters ECParameters = X9ECParameters.getInstance(seq);
            ECCurve curve = ECParameters.getCurve();
            this.domainParameter = new ECParameterSpec(curve, ECParameters.getG(), r, f);
        }
        catch (Exception e) {
            _logger.error("Failed to load proprietary domain parameters", e);
        }
    }

    private void loadDHParameter(ASN1Sequence seq) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

