/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.common;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import org.openecard.common.util.FileUtils;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPTemplate {
    private static final Logger _logger = LoggerFactory.getLogger(HTTPTemplate.class);
    private HashMap<String, String> properties = new HashMap();
    private String content;

    public HTTPTemplate(DocumentRoot documentRoot, String templatePath) {
        try {
            URL url = documentRoot.getFile(templatePath);
            this.content = FileUtils.toString(url.openStream());
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), e);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.toString().getBytes("UTF-8");
    }

    public String toString() {
        StringBuilder out = new StringBuilder(this.content);
        for (String key : this.properties.keySet()) {
            int i = out.indexOf(key);
            int j = i + key.length();
            if (i <= 0 || j <= 0) continue;
            out.replace(i, j, this.properties.get(key));
        }
        return out.toString();
    }
}

