/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import java.util.ArrayList;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.util.StringUtils;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.w3c.dom.Element;

public final class EAC2InputType {
    public static final String CERTIFICATE = "Certificate";
    public static final String SIGNATURE = "Signature";
    public static final String EPHEMERAL_PUBLIC_KEY = "EphemeralPublicKey";
    private final AuthDataMap authMap;
    private ArrayList<CardVerifiableCertificate> certificates = new ArrayList();
    private byte[] ephemeralPublicKey;
    private byte[] signature;

    public EAC2InputType(DIDAuthenticationDataType baseType) throws Exception {
        this.authMap = new AuthDataMap(baseType);
        this.ephemeralPublicKey = this.authMap.getContentAsBytes(EPHEMERAL_PUBLIC_KEY);
        this.signature = this.authMap.getContentAsBytes(SIGNATURE);
        for (Element element : baseType.getAny()) {
            if (!element.getLocalName().equals(CERTIFICATE)) continue;
            byte[] value = StringUtils.toByteArray(element.getTextContent());
            CardVerifiableCertificate cvc = new CardVerifiableCertificate(value);
            this.certificates.add(cvc);
        }
    }

    public ArrayList<CardVerifiableCertificate> getCertificates() {
        return this.certificates;
    }

    public byte[] getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public EAC2OutputType getOutputType() {
        return new EAC2OutputType(this.authMap);
    }
}

