/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.util.Arrays;
import java.util.List;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.ifd.Protocol;
import org.openecard.common.util.ByteUtils;
import org.openecard.ifd.scio.EventListener;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.TransmitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCChannel {
    private static final Logger _logger = LoggerFactory.getLogger(SCChannel.class);
    private final CardChannel channel;
    private final byte[] handle;
    private Protocol smProtocol = null;

    public SCChannel(CardChannel channel, byte[] handle) {
        this.channel = channel;
        this.handle = handle;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    void close() throws CardException {
        if (this.channel.getChannelNumber() != 0) {
            this.channel.close();
        }
    }

    public byte[] transmit(byte[] input, List<byte[]> responses) throws TransmitException, IFDException {
        EventListener.pause();
        try {
            byte[] inputAPDU = input;
            if (this.isSM()) {
                _logger.debug("Apply secure messaging to APDU: {}", (Object)ByteUtils.toHexString(inputAPDU, true));
                inputAPDU = this.smProtocol.applySM(inputAPDU);
            }
            _logger.debug("Send APDU: {}", (Object)ByteUtils.toHexString(inputAPDU, true));
            CommandAPDU capdu = new CommandAPDU(inputAPDU);
            ResponseAPDU rapdu = this.channel.transmit(capdu);
            byte[] result = rapdu.getBytes();
            _logger.debug("Receive APDU: {}", (Object)ByteUtils.toHexString(result, true));
            if (this.isSM()) {
                result = this.smProtocol.removeSM(result);
                _logger.debug("Remove secure messaging from APDU: {}", (Object)ByteUtils.toHexString(result, true));
            }
            byte[] sw = new byte[]{result[result.length - 2], result[result.length - 1]};
            if (responses.isEmpty()) {
                return result;
            }
            for (byte[] expected : responses) {
                if (!Arrays.equals(expected, sw)) continue;
                return result;
            }
            TransmitException tex = new TransmitException(result, CardCommandStatus.getMessage(sw));
            throw tex;
        }
        catch (IllegalArgumentException ex) {
            IFDException ifdex = new IFDException(ex);
            _logger.error(ifdex.getMessage(), ifdex);
            throw ifdex;
        }
        catch (CardException ex) {
            IFDException ifdex = new IFDException(ex);
            _logger.error(ifdex.getMessage(), ifdex);
            throw ifdex;
        }
    }

    private synchronized boolean isSM() {
        boolean result = this.smProtocol != null;
        return result;
    }

    public synchronized void addSecureMessaging(Protocol protocol) {
        this.smProtocol = protocol;
    }

    public synchronized void removeSecureMessaging() {
        this.smProtocol = null;
    }
}

