/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.tls.AbstractTlsContext;
import org.openecard.bouncycastle.crypto.tls.Certificate;
import org.openecard.bouncycastle.crypto.tls.CertificateRequest;
import org.openecard.bouncycastle.crypto.tls.NewSessionTicket;
import org.openecard.bouncycastle.crypto.tls.ProtocolVersion;
import org.openecard.bouncycastle.crypto.tls.SecurityParameters;
import org.openecard.bouncycastle.crypto.tls.TlsCredentials;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsKeyExchange;
import org.openecard.bouncycastle.crypto.tls.TlsPeer;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsServer;
import org.openecard.bouncycastle.crypto.tls.TlsServerContextImpl;
import org.openecard.bouncycastle.crypto.tls.TlsSigner;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;
import org.openecard.bouncycastle.util.Arrays;

public class TlsServerProtocol
extends TlsProtocol {
    protected TlsServer tlsServer = null;
    protected TlsServerContextImpl tlsServerContext = null;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;
    protected TlsKeyExchange keyExchange = null;
    protected TlsCredentials serverCredentials = null;
    protected CertificateRequest certificateRequest = null;
    protected short clientCertificateType = (short)-1;
    protected Certificate clientCertificate = null;
    protected byte[] certificateVerifyHash = null;

    public TlsServerProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        super(input, output, secureRandom);
    }

    public void accept(TlsServer tlsServer) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'tlsServer' cannot be null");
        }
        if (this.tlsServer != null) {
            throw new IllegalStateException("accept can only be called once");
        }
        this.tlsServer = tlsServer;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 0;
        this.securityParameters.serverRandom = TlsServerProtocol.createRandomBlock(this.secureRandom);
        this.tlsServerContext = new TlsServerContextImpl(this.secureRandom, this.securityParameters);
        this.tlsServer.init(this.tlsServerContext);
        this.recordStream.init(this.tlsServerContext);
        this.recordStream.setRestrictReadVersion(false);
        this.completeHandshake();
        this.tlsServer.notifyHandshakeComplete();
    }

    @Override
    protected AbstractTlsContext getContext() {
        return this.tlsServerContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsServer;
    }

    @Override
    protected void handleChangeCipherSpecMessage() throws IOException {
        switch (this.connection_state) {
            case 10: {
                if (this.certificateVerifyHash != null) {
                    this.failWithError((short)2, (short)10);
                }
            }
            case 11: {
                this.connection_state = (short)12;
                break;
            }
            default: {
                this.failWithError((short)2, (short)40);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void handleHandshakeMessage(short type, byte[] data) throws IOException {
        buf = new ByteArrayInputStream(data);
        block0 : switch (type) {
            case 1: {
                switch (this.connection_state) {
                    case 0: {
                        this.receiveClientHelloMessage(buf);
                        this.connection_state = 1;
                        this.sendServerHelloMessage();
                        this.connection_state = (short)2;
                        this.securityParameters.prfAlgorithm = TlsServerProtocol.getPRFAlgorithm(this.selectedCipherSuite);
                        this.securityParameters.compressionAlgorithm = this.selectedCompressionMethod;
                        this.securityParameters.verifyDataLength = 12;
                        this.recordStream.notifyHelloComplete();
                        serverSupplementalData = this.tlsServer.getServerSupplementalData();
                        if (serverSupplementalData != null) {
                            this.sendSupplementalDataMessage(serverSupplementalData);
                        }
                        this.connection_state = (short)3;
                        this.keyExchange = this.tlsServer.getKeyExchange();
                        this.keyExchange.init(this.getContext());
                        this.serverCredentials = this.tlsServer.getCredentials();
                        if (this.serverCredentials == null) {
                            this.keyExchange.skipServerCredentials();
                        } else {
                            this.keyExchange.processServerCredentials(this.serverCredentials);
                            this.sendCertificateMessage(this.serverCredentials.getCertificate());
                        }
                        this.connection_state = (short)4;
                        serverKeyExchange = this.keyExchange.generateServerKeyExchange();
                        if (serverKeyExchange != null) {
                            this.sendServerKeyExchangeMessage(serverKeyExchange);
                        }
                        this.connection_state = (short)5;
                        if (this.serverCredentials != null) {
                            this.certificateRequest = this.tlsServer.getCertificateRequest();
                            if (this.certificateRequest != null) {
                                this.keyExchange.validateCertificateRequest(this.certificateRequest);
                                this.sendCertificateRequestMessage(this.certificateRequest);
                            }
                        }
                        this.connection_state = (short)6;
                        this.sendServerHelloDoneMessage();
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 23: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(TlsServerProtocol.readSupplementalDataMessage(buf));
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 11: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 8: {
                        if (this.certificateRequest == null) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveCertificateMessage(buf);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 16: {
                switch (this.connection_state) {
                    case 7: {
                        this.tlsServer.processClientSupplementalData(null);
                    }
                    case 8: {
                        if (this.certificateRequest != null) ** GOTO lbl70
                        this.keyExchange.skipClientCredentials();
                        ** GOTO lbl79
lbl70:
                        // 1 sources

                        equivalentTLSVersion = this.getContext().getServerVersion().getEquivalentTLSVersion();
                        if (!ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(equivalentTLSVersion)) ** GOTO lbl74
                        this.failWithError((short)2, (short)10);
                        ** GOTO lbl79
lbl74:
                        // 1 sources

                        if (equivalentTLSVersion.isSSL()) {
                            if (this.clientCertificate == null) {
                                this.failWithError((short)2, (short)10);
                            }
                        } else {
                            this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                        }
                    }
lbl79:
                    // 5 sources

                    case 9: {
                        this.receiveClientKeyExchangeMessage(buf);
                        this.connection_state = (short)10;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 15: {
                switch (this.connection_state) {
                    case 10: {
                        if (this.certificateVerifyHash == null) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveCertificateVerifyMessage(buf);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 20: {
                switch (this.connection_state) {
                    case 12: {
                        this.processFinishedMessage(buf);
                        this.connection_state = (short)13;
                        if (this.expectSessionTicket) {
                            this.sendNewSessionTicketMessage(this.tlsServer.getNewSessionTicket());
                        }
                        this.connection_state = (short)14;
                        this.sendChangeCipherSpecMessage();
                        this.connection_state = (short)15;
                        this.sendFinishedMessage();
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    @Override
    protected void handleWarningMessage(short description) throws IOException {
        switch (description) {
            case 41: {
                if (!this.getContext().getServerVersion().isSSL() || this.certificateRequest == null) break;
                this.notifyClientCertificate(Certificate.EMPTY_CHAIN);
                break;
            }
            default: {
                super.handleWarningMessage(description);
            }
        }
    }

    protected void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (this.clientCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        this.clientCertificate = clientCertificate;
        if (clientCertificate.isEmpty()) {
            this.keyExchange.skipClientCredentials();
        } else {
            this.clientCertificateType = TlsUtils.getClientCertificateType(clientCertificate, this.serverCredentials.getCertificate());
            this.keyExchange.processClientCertificate(clientCertificate);
        }
        this.tlsServer.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateMessage(ByteArrayInputStream buf) throws IOException {
        Certificate clientCertificate = Certificate.parse(buf);
        TlsServerProtocol.assertEmpty(buf);
        this.notifyClientCertificate(clientCertificate);
    }

    protected void receiveCertificateVerifyMessage(ByteArrayInputStream buf) throws IOException {
        byte[] clientCertificateSignature = TlsUtils.readOpaque16(buf);
        TlsServerProtocol.assertEmpty(buf);
        try {
            TlsSigner tlsSigner = TlsUtils.createTlsSigner(this.clientCertificateType);
            tlsSigner.init(this.getContext());
            org.openecard.bouncycastle.asn1.x509.Certificate x509Cert = this.clientCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(keyInfo);
            tlsSigner.verifyRawSignature(clientCertificateSignature, publicKey, this.certificateVerifyHash);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void receiveClientHelloMessage(ByteArrayInputStream buf) throws IOException {
        byte[] renegExtValue;
        int cipher_suites_length;
        ProtocolVersion client_version = TlsUtils.readVersion(buf);
        if (client_version.isDTLS()) {
            this.failWithError((short)2, (short)47);
        }
        byte[] client_random = TlsUtils.readFully(32, (InputStream)buf);
        byte[] sessionID = TlsUtils.readOpaque8(buf);
        if (sessionID.length > 32) {
            this.failWithError((short)2, (short)47);
        }
        if ((cipher_suites_length = TlsUtils.readUint16(buf)) < 2 || (cipher_suites_length & 1) != 0) {
            this.failWithError((short)2, (short)50);
        }
        this.offeredCipherSuites = TlsUtils.readUint16Array(cipher_suites_length / 2, buf);
        short compression_methods_length = TlsUtils.readUint8(buf);
        if (compression_methods_length < 1) {
            this.failWithError((short)2, (short)47);
        }
        this.offeredCompressionMethods = TlsUtils.readUint8Array(compression_methods_length, buf);
        this.clientExtensions = TlsServerProtocol.readExtensions(buf);
        this.getContext().setClientVersion(client_version);
        this.tlsServer.notifyClientVersion(client_version);
        this.securityParameters.clientRandom = client_random;
        this.tlsServer.notifyOfferedCipherSuites(this.offeredCipherSuites);
        this.tlsServer.notifyOfferedCompressionMethods(this.offeredCompressionMethods);
        if (TlsServerProtocol.arrayContains(this.offeredCipherSuites, 255)) {
            this.secure_renegotiation = true;
        }
        if (this.clientExtensions != null && (renegExtValue = (byte[])this.clientExtensions.get(EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual(renegExtValue, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                this.failWithError((short)2, (short)40);
            }
        }
        this.tlsServer.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            this.tlsServer.processClientExtensions(this.clientExtensions);
        }
    }

    protected void receiveClientKeyExchangeMessage(ByteArrayInputStream buf) throws IOException {
        this.keyExchange.processClientKeyExchange(buf);
        TlsServerProtocol.assertEmpty(buf);
        TlsServerProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
        this.recordStream.setPendingConnectionState(this.tlsServer.getCompression(), this.tlsServer.getCipher());
        if (this.expectCertificateVerifyMessage()) {
            this.certificateVerifyHash = this.recordStream.getCurrentHash(null);
        }
    }

    protected void sendCertificateRequestMessage(CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)13, buf);
        TlsUtils.writeUint24(0, buf);
        certificateRequest.encode(buf);
        byte[] message = buf.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendNewSessionTicketMessage(NewSessionTicket newSessionTicket) throws IOException {
        if (newSessionTicket == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)4, buf);
        TlsUtils.writeUint24(0, buf);
        newSessionTicket.encode(buf);
        byte[] message = buf.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendServerHelloMessage() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)2, buf);
        TlsUtils.writeUint24(0, buf);
        ProtocolVersion server_version = this.tlsServer.getServerVersion();
        if (!server_version.isEqualOrEarlierVersionOf(this.getContext().getClientVersion())) {
            this.failWithError((short)2, (short)80);
        }
        this.recordStream.setReadVersion(server_version);
        this.recordStream.setWriteVersion(server_version);
        this.recordStream.setRestrictReadVersion(true);
        this.getContext().setServerVersion(server_version);
        TlsUtils.writeVersion(server_version, buf);
        buf.write(this.securityParameters.serverRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, buf);
        this.selectedCipherSuite = this.tlsServer.getSelectedCipherSuite();
        if (!TlsServerProtocol.arrayContains(this.offeredCipherSuites, this.selectedCipherSuite) || this.selectedCipherSuite == 0 || this.selectedCipherSuite == 255) {
            this.failWithError((short)2, (short)80);
        }
        this.selectedCompressionMethod = this.tlsServer.getSelectedCompressionMethod();
        if (!TlsServerProtocol.arrayContains(this.offeredCompressionMethods, this.selectedCompressionMethod)) {
            this.failWithError((short)2, (short)80);
        }
        TlsUtils.writeUint16(this.selectedCipherSuite, buf);
        TlsUtils.writeUint8(this.selectedCompressionMethod, buf);
        this.serverExtensions = this.tlsServer.getServerExtensions();
        if (this.secure_renegotiation) {
            boolean noRenegExt;
            boolean bl = noRenegExt = this.serverExtensions == null || !this.serverExtensions.containsKey(EXT_RenegotiationInfo);
            if (noRenegExt) {
                if (this.serverExtensions == null) {
                    this.serverExtensions = new Hashtable();
                }
                this.serverExtensions.put(EXT_RenegotiationInfo, TlsServerProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (this.serverExtensions != null) {
            this.expectSessionTicket = this.serverExtensions.containsKey(EXT_SessionTicket);
            TlsServerProtocol.writeExtensions(buf, this.serverExtensions);
        }
        byte[] message = buf.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendServerHelloDoneMessage() throws IOException {
        byte[] message = new byte[4];
        TlsUtils.writeUint8((short)14, message, 0);
        TlsUtils.writeUint24(0, message, 1);
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected void sendServerKeyExchangeMessage(byte[] serverKeyExchange) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)12, bos);
        TlsUtils.writeUint24(serverKeyExchange.length, bos);
        bos.write(serverKeyExchange);
        byte[] message = bos.toByteArray();
        this.safeWriteRecord((short)22, message, 0, message.length);
    }

    protected boolean expectCertificateVerifyMessage() {
        return this.clientCertificateType >= 0 && TlsUtils.hasSigningCapability(this.clientCertificateType);
    }
}

