/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.openecard.bouncycastle.crypto.tls.TlsFatalAlert;
import org.openecard.bouncycastle.crypto.tls.TlsProtocol;
import org.openecard.bouncycastle.crypto.tls.TlsUtils;
import org.openecard.bouncycastle.crypto.tls.UseSRTPData;
import org.openecard.bouncycastle.util.Integers;

public class TlsSRTPUtils {
    public static final Integer EXT_use_srtp = Integers.valueOf(14);

    public static void addUseSRTPExtension(Hashtable extensions, UseSRTPData useSRTPData) throws IOException {
        extensions.put(EXT_use_srtp, TlsSRTPUtils.createUseSRTPExtension(useSRTPData));
    }

    public static UseSRTPData getUseSRTPExtension(Hashtable extensions) throws IOException {
        if (extensions == null) {
            return null;
        }
        byte[] extensionValue = (byte[])extensions.get(EXT_use_srtp);
        if (extensionValue == null) {
            return null;
        }
        return TlsSRTPUtils.readUseSRTPExtension(extensionValue);
    }

    public static byte[] createUseSRTPExtension(UseSRTPData useSRTPData) throws IOException {
        if (useSRTPData == null) {
            throw new IllegalArgumentException("'useSRTPData' cannot be null");
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        TlsUtils.writeUint16(2 * protectionProfiles.length, buf);
        TlsUtils.writeUint16Array(protectionProfiles, buf);
        TlsUtils.writeOpaque8(useSRTPData.getMki(), buf);
        return buf.toByteArray();
    }

    public static UseSRTPData readUseSRTPExtension(byte[] extensionValue) throws IOException {
        if (extensionValue == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionValue);
        int length = TlsUtils.readUint16(buf);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] protectionProfiles = TlsUtils.readUint16Array(length / 2, buf);
        byte[] mki = TlsUtils.readOpaque8(buf);
        TlsProtocol.assertEmpty(buf);
        return new UseSRTPData(protectionProfiles, mki);
    }
}

