/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.gui;

import java.util.Map;
import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.ifd.protocol.pace.common.PasswordID;
import org.openecard.ifd.protocol.pace.gui.GUIContentMap;

public class PINStep {
    private static final String TITLE = "step_pace_title";
    private static final String DESCRIPTION = "step_pace_description";
    private I18n lang = I18n.getTranslation("pace");
    private Step step = new Step(this.lang.translationForKey("step_pace_title", new Object[0]));
    private GUIContentMap content;
    private String passwordType;

    public PINStep(GUIContentMap content) {
        this.content = content;
        this.passwordType = PasswordID.parse((Byte)content.get(GUIContentMap.ELEMENT.PIN_ID)).getString();
        this.initialize();
    }

    private void initialize() {
        String stepTitle = this.lang.translationForKey(TITLE, new Object[0]);
        stepTitle = stepTitle.replaceFirst("%s", this.passwordType);
        this.step.setTitle(stepTitle);
        String decriptionText = this.lang.translationForKey(DESCRIPTION, new Object[0]);
        decriptionText = decriptionText.replaceFirst("%s", this.passwordType);
        Text description = new Text();
        description.setText(decriptionText);
        this.step.getInputInfoUnits().add(description);
        PasswordField pinInputField = new PasswordField(this.passwordType);
        pinInputField.setDescription(this.lang.translationForKey(this.passwordType, new Object[0]));
        this.step.getInputInfoUnits().add(pinInputField);
    }

    public Step getStep() {
        return this.step;
    }

    public void processResult(Map<String, ExecutionResults> results) {
        ExecutionResults executionResults = results.get(this.step.getID());
        if (executionResults == null) {
            return;
        }
        PasswordField p = (PasswordField)executionResults.getResult(this.passwordType);
        this.content.add(GUIContentMap.ELEMENT.PIN, (Object)p.getValue());
    }
}

