/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.openecard.bouncycastle.bcpg.BCPGInputStream;
import org.openecard.bouncycastle.bcpg.BCPGOutputStream;
import org.openecard.bouncycastle.bcpg.ContainedPacket;
import org.openecard.bouncycastle.bcpg.UserAttributeSubpacket;
import org.openecard.bouncycastle.bcpg.UserAttributeSubpacketInputStream;

public class UserAttributePacket
extends ContainedPacket {
    private UserAttributeSubpacket[] subpackets;

    public UserAttributePacket(BCPGInputStream in) throws IOException {
        UserAttributeSubpacket sub;
        UserAttributeSubpacketInputStream sIn = new UserAttributeSubpacketInputStream(in);
        Vector<UserAttributeSubpacket> v = new Vector<UserAttributeSubpacket>();
        while ((sub = sIn.readPacket()) != null) {
            v.addElement(sub);
        }
        this.subpackets = new UserAttributeSubpacket[v.size()];
        for (int i = 0; i != this.subpackets.length; ++i) {
            this.subpackets[i] = (UserAttributeSubpacket)v.elementAt(i);
        }
    }

    public UserAttributePacket(UserAttributeSubpacket[] subpackets) {
        this.subpackets = subpackets;
    }

    public UserAttributeSubpacket[] getSubpackets() {
        return this.subpackets;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != this.subpackets.length; ++i) {
            this.subpackets[i].encode(bOut);
        }
        out.writePacket(17, bOut.toByteArray(), false);
    }
}

