/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.genericcryptography;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.InternalAuthenticate;
import org.openecard.common.apdu.ManageSecurityEnvironment;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.anytype.CryptoMarkerType;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.tlv.TLV;
import org.openecard.common.util.ByteUtils;
import org.openecard.sal.protocol.genericcryptography.apdu.PSOComputeDigitalSignature;
import org.openecard.sal.protocol.genericcryptography.apdu.PSOHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignStep
implements ProtocolStep<Sign, SignResponse> {
    private static final Logger logger = LoggerFactory.getLogger(SignStep.class);
    private static final byte BLOCKSIZE = 0;
    private static final byte SET_COMPUTATION = 65;
    private static final byte KEY_REFERENCE_PRIVATE_KEY = -124;
    private final Dispatcher dispatcher;

    public SignStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.Sign;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SignResponse perform(Sign sign, Map<String, Object> internalData) {
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(sign);
            String didName = SALUtils.getDIDName(sign);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            DIDStructureType didStructure = SALUtils.getDIDStructure(sign, didName, cardStateEntry, connectionHandle);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didStructure.getDIDMarker());
            byte[] slotHandle = connectionHandle.getSlotHandle();
            byte[] applicationID = connectionHandle.getCardApplication();
            Assert.securityConditionDID(cardStateEntry, applicationID, didName, CryptographicServiceActionName.SIGN);
            byte[] keyReference = cryptoMarker.getCryptoKeyInfo().getKeyRef().getKeyRef();
            byte[] algorithmIdentifier = cryptoMarker.getAlgorithmInfo().getCardAlgRef();
            if (didStructure.getDIDScope().equals((Object)DIDScopeType.LOCAL)) {
                keyReference[0] = (byte)(0x80 | keyReference[0]);
            }
            byte[] message = sign.getMessage();
            byte[] signature = new byte[]{};
            TLV tagAlgorithmIdentifier = new TLV();
            tagAlgorithmIdentifier.setTagNumWithClass(128L);
            tagAlgorithmIdentifier.setValue(algorithmIdentifier);
            Object var16_18 = null;
            CardResponseAPDU responseAPDU = null;
            String[] signatureGenerationInfo = cryptoMarker.getSignatureGenerationInfo();
            int i = 0;
            while (true) {
                void var16_30;
                if (i >= signatureGenerationInfo.length) {
                    response.setSignature(responseAPDU.getData());
                    return response;
                }
                String command = signatureGenerationInfo[i];
                String nextCmd = "";
                if (i < signatureGenerationInfo.length - 1) {
                    nextCmd = signatureGenerationInfo[i + 1];
                }
                if (command.equals("MSE_KEY")) {
                    byte[] mseData;
                    TLV tagKeyReference = new TLV();
                    tagKeyReference.setTagNumWithClass((byte)-124);
                    tagKeyReference.setValue(keyReference);
                    if (nextCmd.equals("PSO_CDS")) {
                        mseData = ByteUtils.concatenate(tagKeyReference.toBER(), tagAlgorithmIdentifier.toBER());
                        ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -74, mseData);
                    } else {
                        if (!nextCmd.equals("INT_AUTH")) {
                            String msg = "The command 'MSE_KEY' followed by '" + nextCmd + "' is currently not supported.";
                            logger.error(msg);
                            throw new IncorrectParameterException(msg);
                        }
                        mseData = ByteUtils.concatenate(tagKeyReference.toBER(), tagAlgorithmIdentifier.toBER());
                        ManageSecurityEnvironment manageSecurityEnvironment = new ManageSecurityEnvironment(65, -92, mseData);
                    }
                } else if (command.equals("PSO_CDS")) {
                    PSOComputeDigitalSignature pSOComputeDigitalSignature = new PSOComputeDigitalSignature(message, 0);
                } else if (command.equals("INT_AUTH")) {
                    InternalAuthenticate internalAuthenticate = new InternalAuthenticate(message, 0);
                } else if (command.equals("MSE_RESTORE")) {
                    ManageSecurityEnvironment.Restore restore = new ManageSecurityEnvironment.Restore(-74);
                } else if (command.equals("MSE_HASH")) {
                    ManageSecurityEnvironment.Set set = new ManageSecurityEnvironment.Set(65, -86);
                } else if (command.equals("PSO_HASH")) {
                    PSOHash pSOHash = new PSOHash(signature);
                } else if (command.equals("MSE_DS")) {
                    ManageSecurityEnvironment.Set set = new ManageSecurityEnvironment.Set(65, -74);
                } else {
                    if (!command.equals("MSE_KEY_DS")) {
                        String msg = "The signature generation command '" + command + "' is unknown.";
                        throw new IncorrectParameterException(msg);
                    }
                    ManageSecurityEnvironment.Set set = new ManageSecurityEnvironment.Set(65, -74);
                }
                responseAPDU = var16_30.transmit(this.dispatcher, slotHandle);
                ++i;
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
            return response;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }
}

