/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.openecard.addon.AddonManager;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionEntryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE_CODE = System.getProperty("user.language");
    private static final Logger logger = LoggerFactory.getLogger(ActionEntryPanel.class);
    protected final JButton actionBtn;

    public ActionEntryPanel(@Nonnull AddonSpecification addonSpec, @Nonnull AppExtensionSpecification actionSpec, @Nonnull AddonManager manager) {
        this.setLayout(new BoxLayout(this, 0));
        String name = actionSpec.getLocalizedName(LANGUAGE_CODE);
        String description = actionSpec.getLocalizedDescription(LANGUAGE_CODE);
        this.actionBtn = new JButton(name);
        this.add(this.actionBtn);
        Component rigidArea = Box.createRigidArea(new Dimension(15, 0));
        this.add(rigidArea);
        JLabel desc = new JLabel(description);
        desc.setFont(desc.getFont().deriveFont(0));
        this.add(desc);
        AppExtensionAction action = manager.getAppExtensionAction(addonSpec, actionSpec.getId());
        this.addAction(action);
    }

    private void addAction(final AppExtensionAction action) {
        this.actionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        ActionEntryPanel.this.actionBtn.setEnabled(false);
                        action.execute();
                        ActionEntryPanel.this.actionBtn.setEnabled(true);
                        return null;
                    }
                }.execute();
            }
        });
    }
}

