/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient;

import ch.qos.logback.core.joran.spi.JoranException;
import iso.std.iso_iec._24727.tech.schema.EstablishContext;
import iso.std.iso_iec._24727.tech.schema.EstablishContextResponse;
import iso.std.iso_iec._24727.tech.schema.ReleaseContext;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import java.io.IOException;
import java.net.BindException;
import javax.swing.JOptionPane;
import org.openecard.addon.AddonManager;
import org.openecard.common.ClientEnv;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.SALStateCallback;
import org.openecard.control.binding.http.HTTPBinding;
import org.openecard.event.EventManager;
import org.openecard.gui.swing.SwingDialogWrapper;
import org.openecard.gui.swing.SwingUserConsent;
import org.openecard.gui.swing.common.GUIDefaults;
import org.openecard.ifd.protocol.pace.PACEProtocolFactory;
import org.openecard.ifd.scio.IFD;
import org.openecard.management.TinyManagement;
import org.openecard.recognition.CardRecognition;
import org.openecard.richclient.LogbackConfig;
import org.openecard.richclient.gui.AppTray;
import org.openecard.richclient.gui.MessageDialog;
import org.openecard.sal.TinySAL;
import org.openecard.transport.dispatcher.MessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RichClient {
    private static final Logger _logger = LoggerFactory.getLogger(RichClient.class.getName());
    private static final I18n lang = I18n.getTranslation("richclient");
    private AppTray tray;
    private HTTPBinding binding;
    private ClientEnv env = new ClientEnv();
    private IFD ifd;
    private TinySAL sal;
    private AddonManager manager;
    private EventManager em;
    private CardRecognition recognition;
    private CardStateMap cardStates;
    private byte[] contextHandle;

    public static void main(String[] args) {
        RichClient client = new RichClient();
        client.setup();
    }

    public void setup() {
        GUIDefaults.initialize();
        MessageDialog dialog = new MessageDialog();
        dialog.setHeadline(lang.translationForKey("client.startup.failed.headline", new Object[0]));
        try {
            this.tray = new AppTray(this);
            this.tray.beginSetup();
            this.env = new ClientEnv();
            TinyManagement management = new TinyManagement(this.env);
            this.env.setManagement(management);
            this.ifd = new IFD();
            this.ifd.addProtocol("urn:oid:0.4.0.127.0.7.2.2.4", new PACEProtocolFactory());
            this.env.setIFD(this.ifd);
            MessageDispatcher dispatcher = new MessageDispatcher(this.env);
            this.env.setDispatcher(dispatcher);
            this.ifd.setDispatcher(dispatcher);
            EstablishContext establishContext = new EstablishContext();
            EstablishContextResponse establishContextResponse = this.ifd.establishContext(establishContext);
            WSHelper.checkResult(establishContextResponse);
            this.contextHandle = this.ifd.establishContext(establishContext).getContextHandle();
            this.recognition = new CardRecognition(this.ifd, this.contextHandle);
            this.em = new EventManager(this.recognition, this.env, this.contextHandle);
            this.env.setEventManager(this.em);
            this.cardStates = new CardStateMap();
            SALStateCallback salCallback = new SALStateCallback(this.recognition, this.cardStates);
            this.em.registerAllEvents(salCallback);
            this.sal = new TinySAL(this.env, this.cardStates);
            this.env.setSAL(this.sal);
            SwingUserConsent gui = new SwingUserConsent(new SwingDialogWrapper());
            this.sal.setGUI(gui);
            this.ifd.setGUI(gui);
            this.recognition.setGUI(gui);
            try {
                this.binding = new HTTPBinding(24727);
                this.manager = new AddonManager(dispatcher, gui, this.cardStates, this.recognition, this.em);
                this.sal.setAddonManager(this.manager);
                this.binding.setAddonManager(this.manager);
                this.binding.start();
            }
            catch (BindException e) {
                dialog.setMessage(lang.translationForKey("client.startup.failed.portinuse", new Object[0]));
                throw e;
            }
            this.tray.endSetup(this.recognition, this.manager);
            this.em.registerAllEvents(this.tray.status());
            this.em.initialize();
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), e);
            if (dialog.getMessage() == null || dialog.getMessage().isEmpty()) {
                dialog.setMessage(e.getMessage());
            }
            JOptionPane.showMessageDialog(null, dialog, "Open eCard App", -1);
            this.teardown();
        }
    }

    public void teardown() {
        try {
            this.binding.stop();
            this.em.terminate();
            Terminate terminate = new Terminate();
            this.sal.terminate(terminate);
            ReleaseContext releaseContext = new ReleaseContext();
            releaseContext.setContextHandle(this.contextHandle);
            this.ifd.releaseContext(releaseContext);
        }
        catch (Exception ex) {
            _logger.error("Failed to stop Richclient.", ex);
        }
        System.exit(0);
    }

    static {
        try {
            LogbackConfig.load();
        }
        catch (IOException ex) {
            _logger.error("Failed to load logback config from user config.", ex);
        }
        catch (JoranException ex) {
            _logger.error("Failed to load logback config from user config.", ex);
        }
    }
}

