/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.tctoken;

import java.net.URL;
import java.util.List;
import java.util.Map;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.addon.Context;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Body;
import org.openecard.control.module.tctoken.ControlException;
import org.openecard.control.module.tctoken.TCTokenException;
import org.openecard.control.module.tctoken.TCTokenHandler;
import org.openecard.control.module.tctoken.TCTokenRequest;
import org.openecard.control.module.tctoken.TCTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenAction
implements AppPluginAction {
    private static final Logger logger = LoggerFactory.getLogger(TCTokenAction.class);
    private TCTokenHandler genericTCTokenHandler;

    @Override
    public void init(Context ctx) {
        this.genericTCTokenHandler = new TCTokenHandler(ctx.getCardStates(), ctx.getDispatcher(), ctx.getUserConsent(), ctx.getRecognition());
    }

    @Override
    public void destroy() {
    }

    @Override
    public BindingResult execute(Body body, Map<String, String> parameters, List<Attachment> attachments) {
        BindingResult response;
        try {
            TCTokenRequest tcTokenRequest = this.parseParameters(parameters);
            TCTokenResponse tcTokenResponse = this.genericTCTokenHandler.handleActivate(tcTokenRequest);
            response = this.handleResponse(tcTokenResponse);
        }
        catch (ControlException e) {
            response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
            response.setResultMessage(e.getMessage());
        }
        catch (Exception e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            logger.error(e.getMessage(), e);
        }
        return response;
    }

    private TCTokenRequest parseParameters(Map<String, String> parameters) throws TCTokenException {
        if (parameters.containsKey("tcTokenURL")) {
            TCTokenRequest result = this.genericTCTokenHandler.parseTCTokenRequestURI(parameters);
            result.setTokenFromObject(false);
            return result;
        }
        if (parameters.containsKey("activationObject")) {
            TCTokenRequest result = this.genericTCTokenHandler.parseObjectURI(parameters);
            result.setTokenFromObject(true);
            return result;
        }
        throw new TCTokenException("No suitable set of parameters given in the request.");
    }

    private BindingResult handleResponse(TCTokenResponse response) throws Exception {
        BindingResult httpResponse = new BindingResult(BindingResultCode.WRONG_PARAMETER);
        Result result = response.getResult();
        if (result.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok")) {
            if (response.getRefreshAddress() != null) {
                return this.handleRedirectResponse(response.getRefreshAddress());
            }
            httpResponse.setResultCode(BindingResultCode.INTERNAL_ERROR);
        } else {
            if (result.getResultMessage().getValue() != null) {
                return this.handleErrorResponse(result.getResultMessage().getValue());
            }
            httpResponse.setResultCode(BindingResultCode.INTERNAL_ERROR);
        }
        return httpResponse;
    }

    private BindingResult handleRedirectResponse(URL location) {
        BindingResult response = new BindingResult(BindingResultCode.REDIRECT);
        response.addParameter("Location", location.toString());
        return response;
    }

    private BindingResult handleErrorResponse(String message) {
        BindingResult response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
        response.setResultMessage(message);
        return response;
    }
}

