/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.module.status;

import java.util.List;
import java.util.Map;
import org.openecard.addon.Context;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.bind.Attachment;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.addon.bind.Body;
import org.openecard.control.module.status.StatusChangeRequest;
import org.openecard.control.module.status.StatusException;
import org.openecard.control.module.status.WaitForChangeHandler;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.openecard.ws.schema.StatusChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class WaitForChangeAction
implements AppPluginAction {
    private static final Logger logger = LoggerFactory.getLogger(WaitForChangeAction.class);
    private WaitForChangeHandler genericWaitForChangeHandler;
    private WSMarshaller m;

    @Override
    public void init(Context ctx) {
        try {
            this.m = WSMarshallerFactory.createInstance();
            this.m.removeAllTypeClasses();
            this.m.addXmlTypeClass(StatusChange.class);
        }
        catch (WSMarshallerException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        this.genericWaitForChangeHandler = new WaitForChangeHandler(ctx.getEventHandler());
    }

    @Override
    public void destroy() {
    }

    @Override
    public BindingResult execute(Body body, Map<String, String> parameters, List<Attachment> attachments) {
        BindingResult response = null;
        try {
            StatusChangeRequest request = this.checkParameters(parameters);
            StatusChange status = this.genericWaitForChangeHandler.getStatusChange(request);
            if (status == null) {
                String msg = "There is no event queue for the specified session identifier existing.";
                throw new StatusException(msg);
            }
            response = this.handleResponse(status);
        }
        catch (StatusException e) {
            response = new BindingResult(BindingResultCode.WRONG_PARAMETER);
            response.setResultMessage(e.getMessage());
        }
        catch (Exception e) {
            response = new BindingResult(BindingResultCode.INTERNAL_ERROR);
            logger.error(e.getMessage(), e);
        }
        return response;
    }

    private StatusChangeRequest checkParameters(Map<String, String> parameters) throws StatusException {
        if (parameters.containsKey("session")) {
            String value = parameters.get("session");
            if (value != null && !value.isEmpty()) {
                StatusChangeRequest request = new StatusChangeRequest(value);
                return request;
            }
            throw new StatusException("Value for session parameter is missing.");
        }
        for (String s : parameters.keySet()) {
            if (s.equals("session")) continue;
            logger.debug("Unknown query element: {}", (Object)s);
        }
        throw new StatusException("Mandatory parameter session is missing.");
    }

    private BindingResult handleResponse(StatusChange response) throws Exception {
        BindingResult httpResponse = new BindingResult(BindingResultCode.OK);
        Document xml = this.m.marshal(response);
        Body body = new Body(xml, "text/xml");
        httpResponse.setBody(body);
        return httpResponse;
    }
}

