/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.openecard.addon.FileRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

final class PluginDirectoryAlterationListener
implements FilesystemAlterationListener {
    private static final Logger logger = LoggerFactory.getLogger(PluginDirectoryAlterationListener.class.getName());
    private static final String MANIFEST_XML = "META-INF/Addon.xml";
    private final FileRegistry fileRegistry;
    private final WSMarshaller marshaller;

    PluginDirectoryAlterationListener(FileRegistry fileRegistry) throws WSMarshallerException {
        this.fileRegistry = fileRegistry;
        this.marshaller = WSMarshallerFactory.createInstance();
        this.marshaller.addXmlTypeClass(AddonSpecification.class);
    }

    @Override
    public void onFileDelete(File file) {
        this.fileRegistry.unregister(file);
    }

    @Override
    public void onFileCreate(File file) {
        String name = file.getName();
        AddonSpecification abd = this.getAddonSpecificationFromFile(file);
        if (abd == null) {
            return;
        }
        Set<AddonSpecification> plugins = this.fileRegistry.listPlugins();
        for (AddonSpecification desc : plugins) {
            if (!desc.getId().equals(abd.getId())) continue;
            logger.debug("Addon {} is already registered", (Object)name);
            return;
        }
        this.fileRegistry.register(abd, file);
        logger.debug("Successfully registered {} as addon", (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddonSpecification getAddonSpecificationFromFile(File file) {
        AddonSpecification abd;
        JarFile jarFile;
        String name = file.getName();
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            logger.error("File {} will not be registered as plugin because it's not a JarFile.", (Object)name);
            return null;
        }
        try {
            InputStream manifestStream = this.getPluginEntryClass(jarFile);
            if (manifestStream == null) {
                logger.error("File {} will not be registered as plugin because it doesn't contain a Manifest.xml.", (Object)name);
                AddonSpecification addonSpecification = null;
                return addonSpecification;
            }
            this.marshaller.addXmlTypeClass(AddonSpecification.class);
            Document manifestDoc = this.marshaller.str2doc(manifestStream);
            abd = (AddonSpecification)this.marshaller.unmarshal(manifestDoc);
        }
        catch (IOException ex) {
            logger.error("Failed to process Manifest.xml entry for file " + name, ex);
            AddonSpecification addonSpecification = null;
            return addonSpecification;
        }
        catch (MarshallingTypeException e) {
            logger.error("Failed to process Manifest.xml entry for file " + name, e);
            AddonSpecification addonSpecification = null;
            return addonSpecification;
        }
        catch (SAXException e) {
            logger.error("Failed to process Manifest.xml entry for file " + name, e);
            AddonSpecification addonSpecification = null;
            return addonSpecification;
        }
        catch (WSMarshallerException e) {
            logger.error("Failed to process Manifest.xml entry for file " + name, e);
            AddonSpecification addonSpecification = null;
            return addonSpecification;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException ex) {
                logger.error("Failed to close jar file.", ex);
            }
        }
        return abd;
    }

    private InputStream getPluginEntryClass(JarFile jarFile) throws IOException {
        ZipEntry manifest = jarFile.getEntry(MANIFEST_XML);
        if (manifest == null) {
            return null;
        }
        return jarFile.getInputStream(manifest);
    }

    @Override
    public void onStop(FilesystemAlterationObserver observer) {
    }

    @Override
    public void onStart(FilesystemAlterationObserver observer) {
    }

    @Override
    public void onFileChange(File file) {
    }

    @Override
    public void onDirectoryDelete(File file) {
    }

    @Override
    public void onDirectoryCreate(File file) {
    }

    @Override
    public void onDirectoryChange(File file) {
    }
}

